/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.EqualSolutionsComparator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;

public class CrowdingDistanceArchive<S extends Solution>
implements BoundedArchive<S> {
    private int maxSize;
    private List<S> solutionList;
    private Comparator<Solution> dominanceComparator;
    private Comparator<Solution> equalsComparator;
    private Comparator<Solution> crowdingDistanceComparator;
    private DensityEstimator crowdingDistance;

    public CrowdingDistanceArchive(int maxSize) {
        this.maxSize = maxSize;
        this.solutionList = new ArrayList<S>(maxSize + 1);
        this.dominanceComparator = new DominanceComparator();
        this.crowdingDistanceComparator = new CrowdingDistanceComparator();
        this.crowdingDistance = new CrowdingDistance();
        this.equalsComparator = new EqualSolutionsComparator();
    }

    @Override
    public boolean add(S solution) {
        for (int i = 0; i < this.solutionList.size(); ++i) {
            Solution aux = (Solution)this.solutionList.get(i);
            int flag = this.dominanceComparator.compare((Solution)solution, aux);
            if (flag == 1) {
                return false;
            }
            if (flag == -1) {
                this.solutionList.remove(i);
                continue;
            }
            if (this.equalsComparator.compare(aux, (Solution)solution) != 0) continue;
            return false;
        }
        this.solutionList.add(solution);
        if (this.solutionList.size() > this.maxSize) {
            this.crowdingDistance.computeDensityEstimator(this.solutionList);
            int index = new SolutionListUtils().findWorstSolution(this.solutionList, this.crowdingDistanceComparator);
            this.solutionList.remove(index);
        }
        return true;
    }

    @Override
    public List<S> getSolutionList() {
        return this.solutionList;
    }

    public void computeDistance() {
        this.crowdingDistance.computeDensityEstimator(this.solutionList);
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }
}

