/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.comparator.DominanceComparator;

public class NonDominatedSolutionListArchive<S extends Solution>
implements Archive<S> {
    private List<S> solutionList;
    private Comparator<Solution> dominanceComparator;

    public NonDominatedSolutionListArchive() {
        this(new DominanceComparator());
    }

    public NonDominatedSolutionListArchive(DominanceComparator comparator) {
        this.dominanceComparator = comparator;
        this.solutionList = new ArrayList<S>();
    }

    @Override
    public boolean add(S solution) {
        boolean solutionInserted = false;
        if (this.solutionList.size() == 0) {
            this.solutionList.add(solution);
            solutionInserted = true;
        } else {
            Iterator<S> iterator = this.solutionList.iterator();
            while (!solutionInserted && iterator.hasNext()) {
                Solution listIndividual = (Solution)iterator.next();
                int flag = this.dominanceComparator.compare((Solution)solution, listIndividual);
                if (flag == -1) {
                    iterator.remove();
                    continue;
                }
                if (flag == 0) {
                    this.solutionList.add(solution);
                    solutionInserted = true;
                    continue;
                }
                if (flag != 1) continue;
                solutionInserted = false;
            }
        }
        return solutionInserted;
    }

    @Override
    public List<S> getSolutionList() {
        return this.solutionList;
    }
}

