/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;

public class ObjectiveComparator
implements Comparator<Solution> {
    private int nObj;
    private boolean ascendingOrder;

    public ObjectiveComparator(int nObj) {
        this.nObj = nObj;
        this.ascendingOrder = true;
    }

    public ObjectiveComparator(int nObj, boolean descendingOrder) {
        this.nObj = nObj;
        this.ascendingOrder = !descendingOrder;
    }

    @Override
    public int compare(Solution solution1, Solution solution2) {
        if (solution1 == null) {
            return 1;
        }
        if (solution2 == null) {
            return -1;
        }
        double objective1 = solution1.getObjective(this.nObj);
        double objective2 = solution2.getObjective(this.nObj);
        if (this.ascendingOrder) {
            if (objective1 < objective2) {
                return -1;
            }
            if (objective1 > objective2) {
                return 1;
            }
            return 0;
        }
        if (objective1 < objective2) {
            return 1;
        }
        if (objective1 > objective2) {
            return -1;
        }
        return 0;
    }
}

