/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.parallel.impl;

import java.util.concurrent.ExecutorService;
import org.uma.jmetal.util.JMetalLogger;

public abstract class AsynchronousParallelTaskExecutor {
    protected int numberOfThreads;
    protected ExecutorService executor;

    public AsynchronousParallelTaskExecutor(int threads) {
        this.numberOfThreads = threads;
        if (threads == 0) {
            this.numberOfThreads = Runtime.getRuntime().availableProcessors();
        } else if (threads < 0) {
            JMetalLogger.logger.severe("SynchronousParallelRunner: the number of threads cannot be negative number " + threads);
        } else {
            this.numberOfThreads = threads;
        }
        JMetalLogger.logger.info("THREADS: " + this.numberOfThreads);
    }

    public abstract void startParallelRunner(Object var1);

    public abstract void addTaskForExecution(Object[] var1);

    public abstract Object parallelExecution();

    public void stopEvaluator() {
        this.executor.shutdown();
    }
}

