/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.impl;

import java.util.Comparator;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.point.Point;

public class PointComparator
implements Comparator<Point> {
    private boolean maximizing;

    public PointComparator(boolean maximizing) {
        this.maximizing = maximizing;
    }

    @Override
    public int compare(Point pointOne, Point pointTwo) {
        if (pointOne == null) {
            throw new JMetalException("PointOne is null");
        }
        if (pointTwo == null) {
            throw new JMetalException("PointTwo is null");
        }
        if (pointOne.getNumberOfDimensions() != pointTwo.getNumberOfDimensions()) {
            throw new JMetalException("Points have different size: " + pointOne.getNumberOfDimensions() + " and " + pointTwo.getNumberOfDimensions());
        }
        for (int i = pointOne.getNumberOfDimensions() - 1; i >= 0; --i) {
            if (this.isBetter(pointOne.getDimensionValue(i), pointTwo.getDimensionValue(i))) {
                return -1;
            }
            if (!this.isBetter(pointTwo.getDimensionValue(i), pointOne.getDimensionValue(i))) continue;
            return 1;
        }
        return 0;
    }

    private boolean isBetter(double v1, double v2) {
        if (this.maximizing) {
            return v1 > v2;
        }
        return v2 > v1;
    }
}

