/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.solutionattribute.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;

public class CrowdingDistance<S extends Solution>
implements DensityEstimator<S> {
    @Override
    public void computeDensityEstimator(List<S> solutionSet) {
        int size = solutionSet.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            ((Solution)solutionSet.get(0)).setAttribute(this.getAttributeID(), Double.POSITIVE_INFINITY);
            return;
        }
        if (size == 2) {
            ((Solution)solutionSet.get(0)).setAttribute(this.getAttributeID(), Double.POSITIVE_INFINITY);
            ((Solution)solutionSet.get(1)).setAttribute(this.getAttributeID(), Double.POSITIVE_INFINITY);
            return;
        }
        ArrayList<Solution> front = new ArrayList<Solution>(size);
        for (Solution solution : solutionSet) {
            front.add(solution);
        }
        for (int i = 0; i < size; ++i) {
            ((Solution)front.get(i)).setAttribute(this.getAttributeID(), 0.0);
        }
        int numberOfObjectives = ((Solution)solutionSet.get(0)).getNumberOfObjectives();
        for (int i = 0; i < numberOfObjectives; ++i) {
            Collections.sort(front, new ObjectiveComparator(i));
            double objetiveMinn = ((Solution)front.get(0)).getObjective(i);
            double objetiveMaxn = ((Solution)front.get(front.size() - 1)).getObjective(i);
            ((Solution)front.get(0)).setAttribute(this.getAttributeID(), Double.POSITIVE_INFINITY);
            ((Solution)front.get(size - 1)).setAttribute(this.getAttributeID(), Double.POSITIVE_INFINITY);
            for (int j = 1; j < size - 1; ++j) {
                double distance = ((Solution)front.get(j + 1)).getObjective(i) - ((Solution)front.get(j - 1)).getObjective(i);
                distance /= objetiveMaxn - objetiveMinn;
                ((Solution)front.get(j)).setAttribute(this.getAttributeID(), distance += ((Double)((Solution)front.get(j)).getAttribute(this.getAttributeID())).doubleValue());
            }
        }
    }

    @Override
    public void setAttribute(Solution solution, Double value) {
        solution.setAttribute(this.getAttributeID(), value);
    }

    @Override
    public Double getAttribute(Solution solution) {
        return (Double)solution.getAttribute(this.getAttributeID());
    }

    @Override
    public Object getAttributeID() {
        return this.getClass();
    }
}

