/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.solutionattribute.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.impl.OverallConstraintViolationComparator;
import org.uma.jmetal.util.solutionattribute.Ranking;

public class DominanceRanking
implements Ranking<Solution> {
    private static final Comparator<Solution> DOMINANCE_COMPARATOR = new DominanceComparator();
    private static final Comparator<Solution> CONSTRAINT_VIOLATION_COMPARATOR = new OverallConstraintViolationComparator();
    private List<ArrayList<Solution>> rankedSubpopulations = new ArrayList<ArrayList<Solution>>();

    @Override
    public Ranking computeRanking(List<Solution> solutionSet) {
        int i;
        List<Solution> population = solutionSet;
        int[] dominateMe = new int[population.size()];
        List[] iDominate = new List[population.size()];
        List[] front = new List[population.size() + 1];
        for (int i2 = 0; i2 < front.length; ++i2) {
            front[i2] = new LinkedList();
        }
        for (int p = 0; p < population.size(); ++p) {
            iDominate[p] = new LinkedList();
            dominateMe[p] = 0;
        }
        for (int p = 0; p < population.size() - 1; ++p) {
            for (int q = p + 1; q < population.size(); ++q) {
                int flagDominate = CONSTRAINT_VIOLATION_COMPARATOR.compare(solutionSet.get(p), solutionSet.get(q));
                if (flagDominate == 0) {
                    flagDominate = DOMINANCE_COMPARATOR.compare(solutionSet.get(p), solutionSet.get(q));
                }
                if (flagDominate == -1) {
                    iDominate[p].add(q);
                    int n = q;
                    dominateMe[n] = dominateMe[n] + 1;
                    continue;
                }
                if (flagDominate != 1) continue;
                iDominate[q].add(p);
                int n = p;
                dominateMe[n] = dominateMe[n] + 1;
            }
        }
        for (i = 0; i < population.size(); ++i) {
            if (dominateMe[i] != 0) continue;
            front[0].add(i);
            solutionSet.get(i).setAttribute(this.getAttributeID(), 0);
        }
        i = 0;
        while (front[i].size() != 0) {
            Iterator it1 = front[++i - 1].iterator();
            while (it1.hasNext()) {
                Iterator it2 = iDominate[(Integer)it1.next()].iterator();
                while (it2.hasNext()) {
                    int index;
                    int n = index = ((Integer)it2.next()).intValue();
                    dominateMe[n] = dominateMe[n] - 1;
                    if (dominateMe[index] != 0) continue;
                    front[i].add(index);
                    solutionSet.get(index).setAttribute(this.getAttributeID(), i);
                }
            }
        }
        this.rankedSubpopulations = new ArrayList<ArrayList<Solution>>();
        for (int j = 0; j < i; ++j) {
            this.rankedSubpopulations.add(j, new ArrayList(front[j].size()));
            Iterator it1 = front[j].iterator();
            while (it1.hasNext()) {
                this.rankedSubpopulations.get(j).add(solutionSet.get((Integer)it1.next()));
            }
        }
        return this;
    }

    @Override
    public List<Solution> getSubfront(int rank) {
        if (rank >= this.rankedSubpopulations.size()) {
            throw new JMetalException("Invalid rank: " + rank + ". Max rank = " + (this.rankedSubpopulations.size() - 1));
        }
        return this.rankedSubpopulations.get(rank);
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.rankedSubpopulations.size();
    }

    @Override
    public void setAttribute(Solution solution, Integer value) {
        solution.setAttribute(this.getAttributeID(), value);
    }

    @Override
    public Integer getAttribute(Solution solution) {
        return (Integer)solution.getAttribute(this.getAttributeID());
    }

    @Override
    public Object getAttributeID() {
        return this.getClass();
    }
}

