/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.localsearch;

import java.util.Comparator;
import org.uma.jmetal.operator.LocalSearchOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.impl.OverallConstraintViolationComparator;

public class MutationLocalSearch
implements LocalSearchOperator<Solution> {
    private Problem problem;
    private Archive archive;
    private int improvementRounds;
    private Comparator constraintComparator;
    private Comparator dominanceComparator;
    private MutationOperator mutationOperator;
    private int evaluations;

    public MutationLocalSearch(int improvementRounds, MutationOperator mutationOperator, Archive archive, Problem problem) {
        this.problem = problem;
        this.mutationOperator = mutationOperator;
        this.improvementRounds = improvementRounds;
        this.archive = archive;
        this.dominanceComparator = new DominanceComparator();
        this.constraintComparator = new OverallConstraintViolationComparator();
        this.evaluations = 0;
    }

    @Override
    public Solution execute(Solution solution) {
        int i = 0;
        int best = 0;
        this.evaluations = 0;
        int rounds = this.improvementRounds;
        if (rounds <= 0) {
            return solution.copy();
        }
        do {
            ++i;
            Solution mutatedSolution = solution.copy();
            this.mutationOperator.execute(mutatedSolution);
            if (this.problem.getNumberOfConstraints() > 0) {
                ((ConstrainedProblem)this.problem).evaluateConstraints(mutatedSolution);
                best = this.constraintComparator.compare(mutatedSolution, solution);
                if (best == 0) {
                    this.problem.evaluate(mutatedSolution);
                    ++this.evaluations;
                    best = this.dominanceComparator.compare(mutatedSolution, solution);
                } else if (best == -1) {
                    this.problem.evaluate(mutatedSolution);
                    ++this.evaluations;
                }
            } else {
                this.problem.evaluate(mutatedSolution);
                ++this.evaluations;
                best = this.dominanceComparator.compare(mutatedSolution, solution);
            }
            if (best == -1) {
                solution = mutatedSolution;
                continue;
            }
            if (best == 1 || this.archive == null) continue;
            this.archive.add(mutatedSolution);
        } while (i < rounds);
        return solution.copy();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations;
    }
}

