/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.selection;

import java.util.List;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class RandomSelection
implements SelectionOperator<List<? extends Solution>, List<? extends Solution>> {
    private JMetalRandom randomGenerator = JMetalRandom.getInstance();
    private int numberOfSolutionsToBeReturned;

    public RandomSelection() {
        this(1);
    }

    public RandomSelection(int numberOfSolutionsToBeReturned) {
        this.numberOfSolutionsToBeReturned = numberOfSolutionsToBeReturned;
    }

    @Override
    public List<? extends Solution> execute(List<? extends Solution> solutionList) {
        if (null == solutionList) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.isEmpty()) {
            throw new JMetalException("The solution list is empty");
        }
        if (solutionList.size() < this.numberOfSolutionsToBeReturned) {
            throw new JMetalException("The solution list size (" + solutionList.size() + ") is less than " + "the number of requested solutions (" + this.numberOfSolutionsToBeReturned + ")");
        }
        return SolutionListUtils.selectNRandomDifferentSolutions(this.numberOfSolutionsToBeReturned, solutionList);
    }
}

