/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.selection;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.SolutionUtils;
import org.uma.jmetal.util.comparator.DominanceComparator;

public class TournamentSelection
implements SelectionOperator<List<Solution>, Solution> {
    private Comparator<Solution> comparator;
    private final int numberOfTournaments;

    public TournamentSelection(int numberOfTournaments) {
        this(new DominanceComparator(), numberOfTournaments);
    }

    public TournamentSelection(Comparator<Solution> comparator, int numberOfTournaments) {
        this.numberOfTournaments = numberOfTournaments;
        this.comparator = comparator;
    }

    @Override
    public Solution execute(List<Solution> solutionList) {
        Solution result;
        if (null == solutionList) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.isEmpty()) {
            throw new JMetalException("The solution list is empty");
        }
        if (solutionList.size() == 1) {
            result = solutionList.get(0);
        } else {
            result = SolutionListUtils.selectNRandomDifferentSolutions(1, solutionList).get(0);
            int cnt = 1;
            do {
                Solution candidate = SolutionListUtils.selectNRandomDifferentSolutions(1, solutionList).get(0);
                result = SolutionUtils.getBestSolution(result, candidate, this.comparator);
            } while (++cnt < this.numberOfTournaments);
        }
        return result;
    }
}

