/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;
import org.uma.jmetal.util.point.Point;

public class ErrorRatio
extends SimpleDescribedEntity
implements QualityIndicator {
    public ErrorRatio() {
        super("ER", "Error quality indicator");
    }

    @Override
    public double execute(Front paretoFrontApproximation, Front trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.er(paretoFrontApproximation, trueParetoFront);
    }

    @Override
    public double execute(List<? extends Solution> paretoFrontApproximation, List<? extends Solution> trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation list is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front list is null");
        }
        return this.execute(new ArrayFront(paretoFrontApproximation), new ArrayFront(trueParetoFront));
    }

    private double er(Front front, Front referenceFront) throws JMetalException {
        int numberOfObjectives = referenceFront.getPointDimensions();
        double sum = 0.0;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            Point currentPoint = front.getPoint(i);
            boolean thePointIsInTheParetoFront = false;
            for (int j = 0; j < referenceFront.getNumberOfPoints(); ++j) {
                Point currentParetoFrontPoint = referenceFront.getPoint(j);
                boolean found = true;
                for (int k = 0; k < numberOfObjectives; ++k) {
                    if (currentPoint.getDimensionValue(k) == currentParetoFrontPoint.getDimensionValue(k)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                thePointIsInTheParetoFront = found;
                break;
            }
            if (thePointIsInTheParetoFront) continue;
            sum += 1.0;
        }
        return sum / (double)front.getNumberOfPoints();
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

