/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.imp.FrontUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.impl.ArrayPoint;
import org.uma.jmetal.util.point.impl.LexicographicalPointComparator;
import org.uma.jmetal.util.point.impl.PointDimensionComparator;
import org.uma.jmetal.util.point.impl.PointUtils;

public class GeneralizedSpread
extends SimpleDescribedEntity
implements QualityIndicator {
    public GeneralizedSpread() {
        super("GSPREAD", "Generalized SPREAD quality indicator");
    }

    @Override
    public double execute(Front paretoFrontApproximation, Front trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.generalizedSpread(paretoFrontApproximation, trueParetoFront);
    }

    @Override
    public double execute(List<? extends Solution> paretoFrontApproximation, List<? extends Solution> trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.execute(new ArrayFront(paretoFrontApproximation), new ArrayFront(trueParetoFront));
    }

    public double generalizedSpread(Front paretoFront, Front paretoTrueFront) {
        int numberOfObjectives = paretoFront.getPoint(0).getNumberOfDimensions();
        double[] maximumValue = FrontUtils.getMaximumValues(paretoTrueFront);
        double[] minimumValue = FrontUtils.getMinimumValues(paretoTrueFront);
        Front normalizedFront = FrontUtils.getNormalizedFront(paretoFront, maximumValue, minimumValue);
        Front normalizedParetoFront = FrontUtils.getNormalizedFront(paretoTrueFront, maximumValue, minimumValue);
        Point[] extremeValues = new Point[numberOfObjectives];
        for (int i = 0; i < numberOfObjectives; ++i) {
            normalizedParetoFront.sort(new PointDimensionComparator(i));
            ArrayPoint newPoint = new ArrayPoint(numberOfObjectives);
            for (int j = 0; j < numberOfObjectives; ++j) {
                newPoint.setDimensionValue(j, normalizedParetoFront.getPoint(normalizedParetoFront.getNumberOfPoints() - 1).getDimensionValue(j));
            }
            extremeValues[i] = newPoint;
        }
        int numberOfPoints = normalizedFront.getNumberOfPoints();
        normalizedFront.sort(new LexicographicalPointComparator());
        if (PointUtils.euclideanDistance(normalizedFront.getPoint(0), normalizedFront.getPoint(normalizedFront.getNumberOfPoints() - 1)) == 0.0) {
            return 1.0;
        }
        double dmean = 0.0;
        for (int i = 0; i < normalizedFront.getNumberOfPoints(); ++i) {
            dmean += FrontUtils.distanceToNearestPoint(normalizedFront.getPoint(i), normalizedFront);
        }
        dmean /= (double)numberOfPoints;
        double dExtrems = 0.0;
        for (int i = 0; i < extremeValues.length; ++i) {
            dExtrems += FrontUtils.distanceToClosestPoint(extremeValues[i], normalizedFront);
        }
        double mean = 0.0;
        for (int i = 0; i < normalizedFront.getNumberOfPoints(); ++i) {
            mean += Math.abs(FrontUtils.distanceToNearestPoint(normalizedFront.getPoint(i), normalizedFront) - dmean);
        }
        return (dExtrems + mean) / (dExtrems + (double)numberOfPoints * dmean);
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

