/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.imp.FrontUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class GenerationalDistance
extends SimpleDescribedEntity
implements QualityIndicator {
    private static final double POW = 2.0;

    public GenerationalDistance() {
        super("GD", "Generational distance quality indicator");
    }

    @Override
    public double execute(Front paretoFrontApproximation, Front trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.generationalDistance(paretoFrontApproximation, trueParetoFront);
    }

    @Override
    public double execute(List<? extends Solution> paretoFrontApproximation, List<? extends Solution> trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation list is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front list is null");
        }
        return this.generationalDistance(new ArrayFront(paretoFrontApproximation), new ArrayFront(trueParetoFront));
    }

    public double generationalDistance(Front front, Front trueParetoFront) {
        double[] maximumValue = FrontUtils.getMaximumValues(trueParetoFront);
        double[] minimumValue = FrontUtils.getMinimumValues(trueParetoFront);
        Front normalizedFront = FrontUtils.getNormalizedFront(front, maximumValue, minimumValue);
        Front normalizedParetoFront = FrontUtils.getNormalizedFront(trueParetoFront, maximumValue, minimumValue);
        double sum = 0.0;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            sum += Math.pow(FrontUtils.distanceToClosestPoint(normalizedFront.getPoint(i), normalizedParetoFront), 2.0);
        }
        sum = Math.pow(sum, 0.5);
        double generationalDistance = sum / (double)normalizedFront.getNumberOfPoints();
        return generationalDistance;
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

