/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.qualityindicator.util.WfgHypervolume;
import org.uma.jmetal.qualityindicator.util.WfgHypervolumeFront;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.impl.ArrayPoint;
import org.uma.jmetal.util.solutionattribute.impl.HypervolumeContribution;

public class FastHypervolume {
    private static final double DEFAULT_OFFSET = 20.0;
    private Point referencePoint = null;
    private int numberOfObjectives = 0;
    private double offset;

    public FastHypervolume() {
        this(20.0);
    }

    public FastHypervolume(double offset) {
        this.offset = offset;
    }

    public double computeHypervolume(List<? extends Solution> solutionList) {
        double hv;
        if (solutionList.size() == 0) {
            hv = 0.0;
        } else {
            this.numberOfObjectives = solutionList.get(0).getNumberOfObjectives();
            this.referencePoint = new ArrayPoint(this.numberOfObjectives);
            this.updateReferencePoint(solutionList);
            if (this.numberOfObjectives == 2) {
                Collections.sort(solutionList, new ObjectiveComparator(this.numberOfObjectives - 1, ObjectiveComparator.Ordering.DESCENDING));
                hv = this.get2DHV(solutionList);
            } else {
                WfgHypervolume wfgHv = new WfgHypervolume(this.numberOfObjectives, solutionList.size());
                hv = wfgHv.getHV(new WfgHypervolumeFront(solutionList));
            }
        }
        return hv;
    }

    public double computeHypervolume(List<? extends Solution> solutionList, Point referencePoint) {
        double hv = 0.0;
        if (solutionList.size() == 0) {
            hv = 0.0;
        } else {
            this.numberOfObjectives = solutionList.get(0).getNumberOfObjectives();
            this.referencePoint = referencePoint;
            if (this.numberOfObjectives == 2) {
                Collections.sort(solutionList, new ObjectiveComparator(solutionList.size() - 1, ObjectiveComparator.Ordering.DESCENDING));
                hv = this.get2DHV(solutionList);
            } else {
                WfgHypervolume wfgHv = new WfgHypervolume(this.numberOfObjectives, solutionList.size());
                hv = wfgHv.getHV(new WfgHypervolumeFront(solutionList));
            }
        }
        return hv;
    }

    private void updateReferencePoint(List<? extends Solution> solutionList) {
        int i;
        double[] maxObjectives = new double[this.numberOfObjectives];
        for (i = 0; i < this.numberOfObjectives; ++i) {
            maxObjectives[i] = 0.0;
        }
        for (i = 0; i < solutionList.size(); ++i) {
            for (int j = 0; j < this.numberOfObjectives; ++j) {
                if (!(maxObjectives[j] < solutionList.get(i).getObjective(j))) continue;
                maxObjectives[j] = solutionList.get(i).getObjective(j);
            }
        }
        for (i = 0; i < this.referencePoint.getNumberOfDimensions(); ++i) {
            this.referencePoint.setDimensionValue(i, maxObjectives[i] + this.offset);
        }
    }

    private void updateReferencePoint(Front front) {
        int i;
        double[] maxObjectives = new double[this.numberOfObjectives];
        for (i = 0; i < this.numberOfObjectives; ++i) {
            maxObjectives[i] = 0.0;
        }
        for (i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < this.numberOfObjectives; ++j) {
                if (!(maxObjectives[j] < front.getPoint(i).getDimensionValue(j))) continue;
                maxObjectives[j] = front.getPoint(i).getDimensionValue(j);
            }
        }
        for (i = 0; i < this.referencePoint.getNumberOfDimensions(); ++i) {
            this.referencePoint.setDimensionValue(i, maxObjectives[i] + this.offset);
        }
    }

    public double get2DHV(List<? extends Solution> solutionSet) {
        double hv = 0.0;
        if (solutionSet.size() > 0) {
            hv = Math.abs((solutionSet.get(0).getObjective(0) - this.referencePoint.getDimensionValue(0)) * (solutionSet.get(0).getObjective(1) - this.referencePoint.getDimensionValue(1)));
            for (int i = 1; i < solutionSet.size(); ++i) {
                double tmp = Math.abs((solutionSet.get(i).getObjective(0) - this.referencePoint.getDimensionValue(0)) * (solutionSet.get(i).getObjective(1) - solutionSet.get(i - 1).getObjective(1)));
                hv += tmp;
            }
        }
        return hv;
    }

    public void computeHVContributions(List<? extends Solution> solutionList) {
        ArrayList list = (ArrayList)solutionList;
        double[] contributions = new double[list.size()];
        double solutionSetHV = 0.0;
        solutionSetHV = this.computeHypervolume(solutionList);
        for (int i = 0; i < solutionList.size(); ++i) {
            Solution currentPoint = (Solution)list.get(i);
            list.remove(i);
            if (this.numberOfObjectives == 2) {
                contributions[i] = solutionSetHV - this.get2DHV(solutionList);
            } else {
                WfgHypervolumeFront front = new WfgHypervolumeFront(list);
                double hv = new WfgHypervolume(this.numberOfObjectives, list.size()).getHV(front);
                contributions[i] = solutionSetHV - hv;
            }
            list.add(i, currentPoint);
        }
        HypervolumeContribution<Solution> hvContribution = new HypervolumeContribution<Solution>();
        for (int i = 0; i < solutionList.size(); ++i) {
            hvContribution.setAttribute(solutionList.get(i), contributions[i]);
        }
    }

    public double computeSolutionHVContribution(List<? extends Solution> solutionList, int solutionIndex, double solutionSetHV) {
        List<? extends Solution> list = solutionList;
        Solution currentPoint = list.get(solutionIndex);
        list.remove(solutionIndex);
        WfgHypervolumeFront front = new WfgHypervolumeFront(list);
        double hv = new WfgHypervolume(this.numberOfObjectives, list.size(), this.referencePoint).getHV(front);
        double contribution = solutionSetHV - hv;
        list.add(solutionIndex, currentPoint);
        HypervolumeContribution<Solution> hvContribution = new HypervolumeContribution<Solution>();
        hvContribution.setAttribute(list.get(solutionIndex), contribution);
        return contribution;
    }
}

