/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.HashMap;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;
import org.uma.jmetal.util.binarySet.BinarySet;

public class GenericBinarySolution
extends AbstractGenericSolution<BinarySet, BinaryProblem>
implements BinarySolution {
    public GenericBinarySolution(BinaryProblem problem) {
        super(problem);
        int i;
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        for (i = 0; i < problem.getNumberOfVariables(); ++i) {
            this.setVariableValue(i, this.createNewBitSet(problem.getNumberOfBits(i)));
        }
        for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
            this.setObjective(i, 0.0);
        }
    }

    public GenericBinarySolution(GenericBinarySolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((BinaryProblem)this.problem).getNumberOfVariables(); ++i) {
            this.setVariableValue(i, (BinarySet)((BinarySet)solution.getVariableValue(i)).clone());
        }
        for (i = 0; i < ((BinaryProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    private BinarySet createNewBitSet(int numberOfBits) {
        BinarySet bitSet = new BinarySet(numberOfBits);
        for (int i = 0; i < numberOfBits; ++i) {
            double rnd = this.randomGenerator.nextDouble();
            if (rnd < 0.5) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        return bitSet;
    }

    @Override
    public int getNumberOfBits(int index) {
        return ((BinarySet)this.getVariableValue(index)).getBinarySetLength();
    }

    @Override
    public Solution copy() {
        return new GenericBinarySolution(this);
    }

    @Override
    public int getTotalNumberOfBits() {
        int sum = 0;
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            sum += ((BinarySet)this.getVariableValue(i)).getBinarySetLength();
        }
        return sum;
    }

    @Override
    public String getVariableValueString(int index) {
        String result = "";
        for (int i = 0; i < ((BinarySet)this.getVariableValue(index)).getBinarySetLength(); ++i) {
            result = ((BinarySet)this.getVariableValue(index)).get(i) ? result + "1" : result + "0";
        }
        return result;
    }
}

