/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.HashMap;
import org.uma.jmetal.problem.IntegerDoubleProblem;
import org.uma.jmetal.solution.IntegerDoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class GenericIntegerDoubleSolution
extends AbstractGenericSolution<Number, IntegerDoubleProblem>
implements IntegerDoubleSolution {
    private int numberOfIntegerVariables;
    private int numberOfDoubleVariables;

    public GenericIntegerDoubleSolution(IntegerDoubleProblem problem) {
        super(problem);
        Number value;
        int i;
        this.numberOfIntegerVariables = problem.getNumberOfIntegerVariables();
        this.numberOfDoubleVariables = problem.getNumberOfDoubleVariables();
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        for (i = 0; i < this.numberOfIntegerVariables; ++i) {
            value = this.randomGenerator.nextInt((Integer)this.getLowerBound(i), (Integer)this.getUpperBound(i));
            this.setVariableValue(i, value);
        }
        for (i = this.numberOfIntegerVariables; i < this.getNumberOfVariables(); ++i) {
            value = this.randomGenerator.nextDouble((Double)this.getLowerBound(i), (Double)this.getUpperBound(i));
            this.setVariableValue(i, value);
        }
        for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
            this.setObjective(i, 0.0);
        }
    }

    public GenericIntegerDoubleSolution(GenericIntegerDoubleSolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((IntegerDoubleProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        for (i = 0; i < this.numberOfIntegerVariables; ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        for (i = this.numberOfIntegerVariables; i < this.numberOfIntegerVariables + this.numberOfDoubleVariables; ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Number getUpperBound(int index) {
        return ((IntegerDoubleProblem)this.problem).getUpperBound(index);
    }

    @Override
    public int getNumberOfIntegerVariables() {
        return this.numberOfIntegerVariables;
    }

    @Override
    public int getNumberOfDoubleVariables() {
        return this.numberOfDoubleVariables;
    }

    @Override
    public Number getLowerBound(int index) {
        return ((IntegerDoubleProblem)this.problem).getLowerBound(index);
    }

    @Override
    public Solution copy() {
        return new GenericIntegerDoubleSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Number)this.getVariableValue(index)).toString();
    }
}

