/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.uma.jmetal.problem.PermutationProblem;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class GenericIntegerPermutationSolution
extends AbstractGenericSolution<List<Integer>, PermutationProblem>
implements PermutationSolution<List<Integer>> {
    public GenericIntegerPermutationSolution(PermutationProblem<PermutationSolution<Integer>> problem) {
        super(problem);
        int i;
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        ArrayList<Integer> randomSequence = new ArrayList<Integer>(problem.getPermutationLength());
        for (i = 0; i < problem.getPermutationLength(); ++i) {
            randomSequence.add(i);
        }
        Collections.shuffle(randomSequence);
        for (i = 0; i < problem.getPermutationLength(); ++i) {
            this.setVariableValue(i, randomSequence);
        }
    }

    public GenericIntegerPermutationSolution(GenericIntegerPermutationSolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((PermutationProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        for (i = 0; i < ((PermutationProblem)this.problem).getNumberOfVariables(); ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Solution copy() {
        return new GenericIntegerPermutationSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        String result = "";
        for (Integer element : (List)this.getVariableValue(index)) {
            result = result + element + " ";
        }
        return ((List)this.getVariableValue(index)).toString();
    }
}

