/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.HashMap;
import org.uma.jmetal.problem.IntegerProblem;
import org.uma.jmetal.solution.IntegerSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class GenericIntegerSolution
extends AbstractGenericSolution<Integer, IntegerProblem>
implements IntegerSolution {
    public GenericIntegerSolution(IntegerProblem problem) {
        super(problem);
        int i;
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        for (i = 0; i < problem.getNumberOfVariables(); ++i) {
            Integer value = this.randomGenerator.nextInt(this.getLowerBound(i), this.getUpperBound(i));
            this.setVariableValue(i, value);
        }
        for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
            this.setObjective(i, 0.0);
        }
    }

    public GenericIntegerSolution(GenericIntegerSolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((IntegerProblem)this.problem).getNumberOfVariables(); ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        for (i = 0; i < ((IntegerProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Integer getUpperBound(int index) {
        return ((IntegerProblem)this.problem).getUpperBound(index);
    }

    @Override
    public Integer getLowerBound(int index) {
        return ((IntegerProblem)this.problem).getLowerBound(index);
    }

    @Override
    public Solution copy() {
        return new GenericIntegerSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Integer)this.getVariableValue(index)).toString();
    }
}

