/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;

public abstract class AbstractBoundedArchive<S extends Solution>
implements BoundedArchive<S> {
    protected NonDominatedSolutionListArchive list;
    protected int maxSize;

    public AbstractBoundedArchive(int maxSize) {
        this.maxSize = maxSize;
        this.list = new NonDominatedSolutionListArchive();
    }

    @Override
    public boolean add(S solution) {
        boolean success = this.list.add(solution);
        if (success) {
            this.prune();
        }
        return success;
    }

    @Override
    public S get(int index) {
        return (S)((Solution)this.getSolutionList().get(index));
    }

    @Override
    public List<S> getSolutionList() {
        return this.list.getSolutionList();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public abstract void prune();
}

