/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator.impl;

import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ConstraintViolationComparator;

public class ViolationThresholdComparator<S extends Solution>
implements ConstraintViolationComparator {
    private double threshold = 0.0;

    @Override
    public int compare(Solution solution1, Solution solution2) {
        double overall1 = (double)solution1.getNumberOfViolatedConstraints() * solution1.getOverallConstraintViolationDegree();
        double overall2 = (double)solution2.getNumberOfViolatedConstraints() * solution2.getOverallConstraintViolationDegree();
        if (overall1 < 0.0 && overall2 < 0.0) {
            if (overall1 > overall2) {
                return -1;
            }
            if (overall2 > overall1) {
                return 1;
            }
            return 0;
        }
        if (overall1 == 0.0 && overall2 < 0.0) {
            return -1;
        }
        if (overall1 < 0.0 && overall2 == 0.0) {
            return 1;
        }
        return 0;
    }

    public boolean needToCompare(Solution solution1, Solution solution2) {
        double overall1 = Math.abs((double)solution1.getNumberOfViolatedConstraints() * solution1.getOverallConstraintViolationDegree());
        double overall2 = Math.abs((double)solution2.getNumberOfViolatedConstraints() * solution2.getOverallConstraintViolationDegree());
        boolean needToCompare = overall1 > this.threshold || overall2 > this.threshold;
        return needToCompare;
    }

    public double feasibilityRatio(List<S> solutionSet) {
        double aux = 0.0;
        for (int i = 0; i < solutionSet.size(); ++i) {
            if (!(((Solution)solutionSet.get(i)).getOverallConstraintViolationDegree() < 0.0)) continue;
            aux += 1.0;
        }
        return aux / (double)solutionSet.size();
    }

    public double meanOverallViolation(List<S> solutionSet) {
        double aux = 0.0;
        for (int i = 0; i < solutionSet.size(); ++i) {
            aux += Math.abs((double)((Solution)solutionSet.get(i)).getNumberOfViolatedConstraints() * ((Solution)solutionSet.get(i)).getOverallConstraintViolationDegree());
        }
        return aux / (double)solutionSet.size();
    }

    public void updateThreshold(List<S> set) {
        this.threshold = this.feasibilityRatio(set) * this.meanOverallViolation(set);
    }
}

