/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.experiment.ExperimentConfiguration;

public class ExperimentConfigurationBuilder {
    private final String experimentName;
    private List<Algorithm> algorithmList;
    private List<Problem> problemList;
    private String experimentBaseDirectory;
    private String outputParetoFrontFileName;
    private String outputParetoSetFileName;
    private int independentRuns;

    public ExperimentConfigurationBuilder(String experimentName) {
        this.experimentName = experimentName;
    }

    public ExperimentConfigurationBuilder setAlgorithmList(List<Algorithm> algorithmList) {
        this.algorithmList = new ArrayList<Algorithm>(algorithmList);
        return this;
    }

    public ExperimentConfigurationBuilder setProblemList(List<Problem> problemList) {
        this.problemList = new ArrayList<Problem>(problemList);
        return this;
    }

    public ExperimentConfigurationBuilder setExperimentBaseDirectory(String experimentBaseDirectory) {
        this.experimentBaseDirectory = experimentBaseDirectory + "/" + this.experimentName;
        return this;
    }

    public ExperimentConfigurationBuilder setOutputParetoFrontFileName(String outputParetoFrontFileName) {
        this.outputParetoFrontFileName = outputParetoFrontFileName;
        return this;
    }

    public ExperimentConfigurationBuilder setOutputParetoSetFileName(String outputParetoSetFileName) {
        this.outputParetoSetFileName = outputParetoSetFileName;
        return this;
    }

    public ExperimentConfigurationBuilder setIndependentRuns(int independentRuns) {
        this.independentRuns = independentRuns;
        return this;
    }

    public ExperimentConfiguration build() {
        return new ExperimentConfiguration(this);
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public List<Algorithm> getAlgorithmList() {
        return this.algorithmList;
    }

    public List<Problem> getProblemList() {
        return this.problemList;
    }

    public String getExperimentBaseDirectory() {
        return this.experimentBaseDirectory;
    }

    public String getOutputParetoFrontFileName() {
        return this.outputParetoFrontFileName;
    }

    public String getOutputParetoSetFileName() {
        return this.outputParetoSetFileName;
    }

    public int getIndependentRuns() {
        return this.independentRuns;
    }
}

