/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.parallel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.parallel.SynchronousParallelTaskExecutor;

public class MultithreadedEvaluator
implements SynchronousParallelTaskExecutor {
    private Problem problem;
    private Collection<EvaluationTask> taskList;
    private int numberOfThreads;
    private ExecutorService executor;

    public MultithreadedEvaluator(int threads) {
        this.numberOfThreads = threads;
        if (threads == 0) {
            this.numberOfThreads = Runtime.getRuntime().availableProcessors();
        } else if (threads < 0) {
            JMetalLogger.logger.severe("MultithreadedEvaluator: the number of threads cannot be negative number " + threads);
        } else {
            this.numberOfThreads = threads;
        }
        JMetalLogger.logger.info("THREADS: " + this.numberOfThreads);
    }

    @Override
    public void start(Object problem) {
        this.problem = (Problem)problem;
        this.executor = Executors.newFixedThreadPool(this.numberOfThreads);
        JMetalLogger.logger.info("Cores: " + this.numberOfThreads);
        this.taskList = null;
    }

    @Override
    public void addTask(Object[] taskParameters) {
        Solution solution = (Solution)taskParameters[0];
        if (this.taskList == null) {
            this.taskList = new ArrayList<EvaluationTask>();
        }
        this.taskList.add(new EvaluationTask(this.problem, solution));
    }

    @Override
    public Object parallelExecution() {
        List future = null;
        try {
            future = this.executor.invokeAll(this.taskList);
        }
        catch (InterruptedException e1) {
            JMetalLogger.logger.log(Level.SEVERE, "Error", e1);
        }
        Vector<Object> solutionList = new Vector<Object>();
        for (Future result : future) {
            Object solution = null;
            try {
                solution = result.get();
                solutionList.add(solution);
            }
            catch (InterruptedException e) {
                JMetalLogger.logger.log(Level.SEVERE, "Error", e);
            }
            catch (ExecutionException e) {
                JMetalLogger.logger.log(Level.SEVERE, "Error", e);
            }
        }
        this.taskList = null;
        return solutionList;
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }

    private class EvaluationTask
    implements Callable<Object> {
        private Problem problem;
        private Solution solution;

        public EvaluationTask(Problem problem, Solution solution) {
            this.problem = problem;
            this.solution = solution;
        }

        @Override
        public Solution call() throws Exception {
            this.problem.evaluate(this.solution);
            return this.solution;
        }
    }
}

