/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.parameter.configuration.impl;

import org.uma.jmetal.parameter.Parameter;
import org.uma.jmetal.parameter.configuration.ConfigurationUnit;

public class ImmutableConfigurationUnit<Value>
implements ConfigurationUnit<Value> {
    private final Parameter<Value> parameter;
    private final Value value;

    public ImmutableConfigurationUnit(Parameter<Value> parameter, Value value) {
        if (parameter == null) {
            throw new NullPointerException("No parameter provided");
        }
        this.parameter = parameter;
        this.value = value;
    }

    @Override
    public Parameter<Value> getParameter() {
        return this.parameter;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public void apply() {
        this.parameter.set(this.value);
    }

    @Override
    public boolean isApplied() {
        Value current = this.parameter.get();
        return current == this.value || current != null && current.equals(this.value);
    }
}

