/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.parameter.configuration.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.uma.jmetal.parameter.Parameter;
import org.uma.jmetal.parameter.Parameterable;
import org.uma.jmetal.parameter.configuration.Configuration;
import org.uma.jmetal.parameter.configuration.ConfigurationUnit;
import org.uma.jmetal.parameter.configuration.impl.ImmutableConfigurationUnit;

public class SimpleConfiguration
implements Configuration {
    Map<Parameter<?>, ConfigurationUnit<?>> unitMap = new HashMap();

    public SimpleConfiguration(ConfigurationUnit<?> ... units) {
        this(Arrays.asList(units));
    }

    public SimpleConfiguration(Iterable<ConfigurationUnit<?>> units) {
        this.setAllUnits(units);
    }

    public SimpleConfiguration(Parameterable algorithm) {
        for (Parameter parameter : algorithm.getParameterManager()) {
            this.storeValue(parameter);
        }
    }

    private <Value> void storeValue(Parameter<Value> parameter) {
        this.setUnit(new ImmutableConfigurationUnit<Value>(parameter, parameter.get()));
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return new LinkedList(this.unitMap.keySet());
    }

    public <Value> Value getValue(Parameter<Value> parameter) {
        ConfigurationUnit<Value> unit = this.getUnit(parameter);
        if (unit == null) {
            return null;
        }
        return unit.getValue();
    }

    public <Value> void setValue(Parameter<Value> parameter, Value value) {
        this.setUnit(new ImmutableConfigurationUnit<Value>(parameter, value));
    }

    public void removeValue(Parameter<?> parameter) {
        this.removeUnit(parameter);
    }

    @Override
    public <Value> ConfigurationUnit<Value> getUnit(Parameter<Value> parameter) {
        return this.unitMap.get(parameter);
    }

    public <Value> void setUnit(ConfigurationUnit<Value> unit) {
        this.unitMap.put(unit.getParameter(), unit);
    }

    public void removeUnit(Parameter<?> parameter) {
        this.unitMap.remove(parameter);
    }

    public Map<Parameter<?>, ConfigurationUnit<?>> getAllUnits(Iterable<Parameter<?>> parameters) {
        HashMap map = new HashMap();
        for (Parameter<?> parameter : parameters) {
            map.put(parameter, this.getUnit(parameter));
        }
        return map;
    }

    public void setAllUnits(Iterable<ConfigurationUnit<?>> units) {
        for (ConfigurationUnit<?> unit : units) {
            this.setUnit(unit);
        }
    }

    public void removeAllUnits(Iterable<Parameter<?>> parameters) {
        for (Parameter<?> parameter : parameters) {
            this.removeUnit(parameter);
        }
    }

    public Map<Parameter<?>, Object> getAllValues(Iterable<Parameter<?>> parameters) {
        HashMap map = new HashMap();
        for (Parameter<?> parameter : parameters) {
            map.put(parameter, this.getValue(parameter));
        }
        return map;
    }

    public <Value> void setAllValues(Map<Parameter<Value>, Value> map) {
        for (Map.Entry<Parameter<Value>, Value> entry : map.entrySet()) {
            Parameter<Value> parameter = entry.getKey();
            Value value = entry.getValue();
            this.setValue(parameter, value);
        }
    }

    public void removeAllValues(Iterable<Parameter<?>> parameters) {
        this.removeAllUnits(parameters);
    }

    @Override
    public void applyAll() {
        for (ConfigurationUnit<?> unit : this) {
            unit.apply();
        }
    }

    @Override
    public boolean isAllApplied() {
        for (ConfigurationUnit<?> unit : this) {
            if (unit.isApplied()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ConfigurationUnit<?>> iterator() {
        return this.unitMap.values().iterator();
    }
}

