/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class Epsilon
extends SimpleDescribedEntity
implements QualityIndicator {
    public Epsilon() {
        super("EPSILON", "Additive Epsilon indicator");
    }

    @Override
    public double execute(Front paretoFrontApproximation, Front trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.epsilon(paretoFrontApproximation, trueParetoFront);
    }

    @Override
    public <S extends Solution<?>> double execute(List<S> paretoFrontApproximation, List<S> trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation list is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front list is null");
        }
        return this.execute(new ArrayFront(paretoFrontApproximation), new ArrayFront(trueParetoFront));
    }

    @Override
    public String getName() {
        return super.getName();
    }

    private double epsilon(Front front, Front referenceFront) throws JMetalException {
        double epsJ = 0.0;
        double epsK = 0.0;
        int numberOfObjectives = front.getPointDimensions();
        double eps = Double.MIN_VALUE;
        for (int i = 0; i < referenceFront.getNumberOfPoints(); ++i) {
            for (int j = 0; j < front.getNumberOfPoints(); ++j) {
                for (int k = 0; k < numberOfObjectives; ++k) {
                    double epsTemp = front.getPoint(j).getDimensionValue(k) - referenceFront.getPoint(i).getDimensionValue(k);
                    if (k == 0) {
                        epsK = epsTemp;
                        continue;
                    }
                    if (!(epsK < epsTemp)) continue;
                    epsK = epsTemp;
                }
                if (j == 0) {
                    epsJ = epsK;
                    continue;
                }
                if (!(epsJ > epsK)) continue;
                epsJ = epsK;
            }
            if (i == 0) {
                eps = epsJ;
                continue;
            }
            if (!(eps < epsJ)) continue;
            eps = epsJ;
        }
        return eps;
    }
}

