/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class R2
extends SimpleDescribedEntity
implements QualityIndicator {
    double[][] matrix = null;
    double[][] lambda = null;
    int numberOfObjectives = 2;

    public R2() {
        super("R2", "R2 quality indicator");
        this.lambda = new double[100][2];
        for (int n = 0; n < 100; ++n) {
            double a;
            this.lambda[n][0] = a = 1.0 * (double)n / 99.0;
            this.lambda[n][1] = 1.0 - a;
        }
    }

    public R2(int nVectors) {
        super("R2", "R2 quality indicator");
        this.lambda = new double[nVectors][2];
        for (int n = 0; n < nVectors; ++n) {
            double a;
            this.lambda[n][0] = a = 1.0 * (double)n / (double)(nVectors - 1);
            this.lambda[n][1] = 1.0 - a;
        }
    }

    @Override
    public double execute(Front paretoFrontApproximation, Front trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.r2(paretoFrontApproximation, trueParetoFront);
    }

    @Override
    public <S extends Solution<?>> double execute(List<S> paretoFrontApproximation, List<S> trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.r2(new ArrayFront(paretoFrontApproximation), new ArrayFront(trueParetoFront));
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public double r2(Front approximation, Front paretoFront) {
        int numberOfObjectives = approximation.getPoint(0).getNumberOfDimensions();
        double[] maximumValue = FrontUtils.getMaximumValues(paretoFront);
        double[] minimumValue = FrontUtils.getMinimumValues(paretoFront);
        Front normalizedApproximation = FrontUtils.getNormalizedFront(approximation, maximumValue, minimumValue);
        this.matrix = new double[approximation.getNumberOfPoints()][this.lambda.length];
        for (int i = 0; i < approximation.getNumberOfPoints(); ++i) {
            for (int j = 0; j < this.lambda.length; ++j) {
                this.matrix[i][j] = this.lambda[j][0] * Math.abs(normalizedApproximation.getPoint(i).getDimensionValue(0));
                for (int n = 1; n < numberOfObjectives; ++n) {
                    this.matrix[i][j] = Math.max(this.matrix[i][j], this.lambda[j][n] * Math.abs(normalizedApproximation.getPoint(i).getDimensionValue(n)));
                }
            }
        }
        double sum = 0.0;
        for (int i = 0; i < this.lambda.length; ++i) {
            double tmp = this.matrix[0][i];
            for (int j = 1; j < approximation.getNumberOfPoints(); ++j) {
                tmp = Math.min(tmp, this.matrix[j][i]);
            }
            sum += tmp;
        }
        return sum / (double)this.lambda.length;
    }
}

