/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class SetCoverage
extends SimpleDescribedEntity
implements QualityIndicator {
    private Comparator<Solution<?>> dominance;

    public SetCoverage() {
        super("SC", "Set coverage");
    }

    @Override
    public double execute(Front frontA, Front frontB) {
        if (frontA == null) {
            throw new JMetalException("The front A is null");
        }
        if (frontB == null) {
            throw new JMetalException("The front B is null");
        }
        return this.setCoverage(FrontUtils.convertFrontToSolutionList(frontA), FrontUtils.convertFrontToSolutionList(frontB));
    }

    @Override
    public <S extends Solution<?>> double execute(List<S> solutionListA, List<S> solutionListB) {
        if (solutionListA == null) {
            throw new JMetalException("The list A is null");
        }
        if (solutionListB == null) {
            throw new JMetalException("The list B is null");
        }
        return this.setCoverage(solutionListA, solutionListB);
    }

    public double setCoverage(List<? extends Solution<?>> set1, List<? extends Solution<?>> set2) {
        double result;
        int sum = 0;
        if (set2.size() == 0) {
            result = set1.size() == 0 ? 0.0 : 1.0;
        } else {
            this.dominance = new DominanceComparator();
            for (int i = 0; i < set2.size(); ++i) {
                if (!SolutionListUtils.isSolutionDominatedBySolutionList(set2.get(i), set1)) continue;
                ++sum;
            }
            result = (double)sum / (double)set2.size();
        }
        return result;
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

