/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import java.util.Iterator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AdaptiveGrid;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.comparator.DominanceComparator;

public class AdaptiveGridArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private AdaptiveGrid<S> grid;
    private int maxSize;
    private Comparator<S> dominanceComparator = new DominanceComparator();

    public AdaptiveGridArchive(int maxSize, int bisections, int objectives) {
        super(maxSize);
        this.grid = new AdaptiveGrid(bisections, objectives);
    }

    @Override
    public boolean add(S solution) {
        Iterator iterator = this.getSolutionList().iterator();
        while (iterator.hasNext()) {
            Solution element = (Solution)iterator.next();
            int flag = this.dominanceComparator.compare(solution, element);
            if (flag == -1) {
                iterator.remove();
                int location = this.grid.location(element);
                if (this.grid.getLocationDensity(location) > 1) {
                    this.grid.removeSolution(location);
                    continue;
                }
                this.grid.updateGrid(this.getSolutionList());
                continue;
            }
            if (flag != 1) continue;
            return false;
        }
        if (this.size() == 0) {
            this.getSolutionList().add(solution);
            this.grid.updateGrid(this.getSolutionList());
            return true;
        }
        if (this.getSolutionList().size() < this.getMaxSize()) {
            this.grid.updateGrid(solution, this.getSolutionList());
            int location = this.grid.location(solution);
            this.grid.addSolution(location);
            this.getSolutionList().add(solution);
            return true;
        }
        this.grid.updateGrid(solution, this.getSolutionList());
        int location = this.grid.location(solution);
        if (location == this.grid.getMostPopulatedHypercube()) {
            return false;
        }
        this.prune();
        this.grid.addSolution(location);
        this.getSolutionList().add(solution);
        return true;
    }

    public AdaptiveGrid<S> getGrid() {
        return this.grid;
    }

    @Override
    public void prune() {
        Iterator iterator = this.getSolutionList().iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            Solution element;
            int location2;
            if (removed || (location2 = this.grid.location(element = (Solution)iterator.next())) != this.grid.getMostPopulatedHypercube()) continue;
            iterator.remove();
            this.grid.removeSolution(location2);
        }
    }
}

