/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.qualityindicator.util.FastHypervolume;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.comparator.HypervolumeContributorComparator;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.impl.ArrayPoint;

public class FastHypervolumeArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    public Point referencePoint;
    private Comparator<Solution<?>> hvContributionComparator;

    public FastHypervolumeArchive(int maxSize, int numberOfObjectives) {
        super(maxSize);
        this.referencePoint = new ArrayPoint(numberOfObjectives);
        for (int i = 0; i < numberOfObjectives; ++i) {
            this.referencePoint.setDimensionValue(i, Double.MAX_VALUE);
        }
        this.hvContributionComparator = new HypervolumeContributorComparator();
    }

    public void computeHVContribution() {
        FastHypervolume fastHV = new FastHypervolume();
        fastHV.computeHVContributions(this.getSolutionList());
    }

    @Override
    public void prune() {
        if (this.getSolutionList().size() > this.getMaxSize()) {
            this.computeHVContribution();
            this.getSolutionList().remove(SolutionListUtils.findIndexOfWorstSolution(this.getSolutionList(), this.hvContributionComparator));
        }
    }
}

