/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.impl;

import java.io.File;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.experiment.ExperimentComponent;
import org.uma.jmetal.util.experiment.ExperimentConfiguration;

public class AlgorithmExecution
implements ExperimentComponent {
    private ExperimentConfiguration<?> configuration;

    public AlgorithmExecution(ExperimentConfiguration<?> configuration) {
        this.configuration = configuration;
    }

    @Override
    public void run() {
        JMetalLogger.logger.info("ExperimentExecution: Preparing output directory");
        this.prepareOutputDirectory();
    }

    private void prepareOutputDirectory() {
        if (this.experimentDirectoryDoesNotExist()) {
            this.createExperimentDirectory();
        }
    }

    private boolean experimentDirectoryDoesNotExist() {
        File experimentDirectory = new File(this.configuration.getExperimentBaseDirectory());
        boolean result = !experimentDirectory.exists() || !experimentDirectory.isDirectory();
        return result;
    }

    private void createExperimentDirectory() {
        boolean result;
        File experimentDirectory = new File(this.configuration.getExperimentBaseDirectory());
        if (experimentDirectory.exists()) {
            experimentDirectory.delete();
        }
        if (!(result = new File(this.configuration.getExperimentBaseDirectory()).mkdirs())) {
            throw new JMetalException("Error creating experiment directory: " + this.configuration.getExperimentBaseDirectory());
        }
    }
}

