/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.parallel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.experiment.ExperimentConfiguration;
import org.uma.jmetal.util.experiment.impl.AlgorithmExecution;
import org.uma.jmetal.util.parallel.SynchronousParallelTaskExecutor;

public class MultithreadedExperimentExecutor
implements SynchronousParallelTaskExecutor {
    private Collection<EvaluationTask> taskList;
    private AlgorithmExecution experimentExecution;
    private int numberOfThreads;
    private ExecutorService executor;

    public MultithreadedExperimentExecutor(int threads) {
        this.numberOfThreads = threads;
        if (threads == 0) {
            this.numberOfThreads = Runtime.getRuntime().availableProcessors();
        } else if (threads < 0) {
            JMetalLogger.logger.severe("MultithreadedExperimentExecutor: the number of threads cannot be negative number " + threads);
        } else {
            this.numberOfThreads = threads;
        }
        JMetalLogger.logger.info("THREADS: " + this.numberOfThreads);
    }

    @Override
    public void start(Object object) {
        this.experimentExecution = (AlgorithmExecution)object;
        this.executor = Executors.newFixedThreadPool(this.numberOfThreads);
        JMetalLogger.logger.info("Cores: " + this.numberOfThreads);
        this.taskList = null;
    }

    @Override
    public void addTask(Object[] taskParameters) {
        if (this.taskList == null) {
            this.taskList = new ArrayList<EvaluationTask>();
        }
        String algorithm = (String)taskParameters[0];
        String problem = (String)taskParameters[1];
        Integer id = (Integer)taskParameters[2];
        ExperimentConfiguration experimentData = (ExperimentConfiguration)taskParameters[3];
        this.taskList.add(new EvaluationTask(algorithm, problem, id, experimentData));
    }

    @Override
    public Object parallelExecution() {
        List future = null;
        try {
            future = this.executor.invokeAll(this.taskList);
        }
        catch (InterruptedException e1) {
            JMetalLogger.logger.log(Level.SEVERE, "Error", e1);
        }
        Vector<Object> resultList = new Vector<Object>();
        for (Future result : future) {
            Object returnValue = null;
            try {
                returnValue = result.get();
                resultList.add(returnValue);
            }
            catch (InterruptedException e) {
                JMetalLogger.logger.log(Level.SEVERE, "Error", e);
            }
            catch (ExecutionException e) {
                JMetalLogger.logger.log(Level.SEVERE, "Error", e);
            }
        }
        this.taskList = null;
        return null;
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }

    private class EvaluationTask
    implements Callable<Object> {
        private String problemName;
        private String algorithmName;
        private int id;
        private ExperimentConfiguration<?> experimentData;

        public EvaluationTask(String algorithm, String problem, int id, ExperimentConfiguration<?> experimentData) {
            JMetalLogger.logger.info(" Task: " + this.algorithmName + ", problem: " + this.problemName + ", run: " + id);
            this.problemName = problem;
            this.algorithmName = algorithm;
            this.id = id;
            this.experimentData = experimentData;
        }

        @Override
        public Integer call() throws Exception {
            return this.id;
        }
    }
}

