/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class PermutationSwapMutation<T>
implements MutationOperator<PermutationSolution<T>> {
    private double mutationProbability;
    private JMetalRandom randomGenerator;

    public PermutationSwapMutation(double mutationProbability) {
        if (mutationProbability < 0.0 || mutationProbability > 1.0) {
            throw new JMetalException("Mutation probability value invalid: " + mutationProbability);
        }
        this.mutationProbability = mutationProbability;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    @Override
    public PermutationSolution<T> execute(PermutationSolution<T> solution) {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(solution);
        return solution;
    }

    public void doMutation(PermutationSolution<T> solution) {
        int permutationLength = solution.getNumberOfVariables();
        if (permutationLength != 0 && permutationLength != 1 && this.randomGenerator.nextDouble() < this.mutationProbability) {
            int pos1 = this.randomGenerator.nextInt(0, permutationLength - 1);
            int pos2 = this.randomGenerator.nextInt(0, permutationLength - 1);
            while (pos1 == pos2) {
                if (pos1 == permutationLength - 1) {
                    pos2 = this.randomGenerator.nextInt(0, permutationLength - 2);
                    continue;
                }
                pos2 = this.randomGenerator.nextInt(pos1, permutationLength - 1);
            }
            Object temp = solution.getVariableValue(pos1);
            solution.setVariableValue(pos1, solution.getVariableValue(pos2));
            solution.setVariableValue(pos2, temp);
        }
    }
}

