/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.crossover;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DifferentialEvolutionCrossover
implements CrossoverOperator<DoubleSolution> {
    private static final double DEFAULT_CR = 0.5;
    private static final double DEFAULT_F = 0.5;
    private static final double DEFAULT_K = 0.5;
    private static final String DEFAULT_DE_VARIANT = "rand/1/bin";
    private static final String[] VALID_VARIANTS = new String[]{"rand/1/bin", "best/1/bin", "rand/1/exp", "best/1/exp", "current-to-rand/1", "current-to-best/1", "current-to-rand/1/bin", "current-to-best/1/bin", "current-to-rand/1/exp", "current-to-best/1/exp"};
    private double cr;
    private double f;
    private double k;
    private String variant;
    private DoubleSolution currentSolution;
    private JMetalRandom randomGenerator;

    public DifferentialEvolutionCrossover() {
        this(0.5, 0.5, 0.5, DEFAULT_DE_VARIANT);
    }

    public DifferentialEvolutionCrossover(double cr, double f, String variant) {
        this.cr = cr;
        this.f = f;
        this.k = 0.5;
        this.variant = variant;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    public DifferentialEvolutionCrossover(double cr, double f, double k, String variant) {
        this(cr, f, variant);
        this.k = k;
    }

    public double getCr() {
        return this.cr;
    }

    public double getF() {
        return this.f;
    }

    public double getK() {
        return this.k;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setCurrentSolution(DoubleSolution current) {
        this.currentSolution = current;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> parentSolutions) {
        int j;
        DoubleSolution child = (DoubleSolution)this.currentSolution.copy();
        int numberOfVariables = parentSolutions.get(0).getNumberOfVariables();
        int jrand = this.randomGenerator.nextInt(0, numberOfVariables - 1);
        if (DEFAULT_DE_VARIANT.equals(this.variant) || "best/1/bin".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value;
                if (this.randomGenerator.nextDouble(0.0, 1.0) < this.cr || j == jrand) {
                    value = (Double)parentSolutions.get(2).getVariableValue(j) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                    if (value < child.getLowerBound(j)) {
                        value = child.getLowerBound(j);
                    }
                    if (value > child.getUpperBound(j)) {
                        value = child.getUpperBound(j);
                    }
                    child.setVariableValue(j, value);
                    continue;
                }
                value = (Double)this.currentSolution.getVariableValue(j);
                child.setVariableValue(j, value);
            }
        } else if ("rand/1/exp".equals(this.variant) || "best/1/exp".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value;
                if (this.randomGenerator.nextDouble(0.0, 1.0) < this.cr || j == jrand) {
                    value = (Double)parentSolutions.get(2).getVariableValue(j) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                    if (value < child.getLowerBound(j)) {
                        value = child.getLowerBound(j);
                    }
                    if (value > child.getUpperBound(j)) {
                        value = child.getUpperBound(j);
                    }
                    child.setVariableValue(j, value);
                    continue;
                }
                this.cr = 0.0;
                value = (Double)this.currentSolution.getVariableValue(j);
                child.setVariableValue(j, value);
            }
        } else if ("current-to-rand/1".equals(this.variant) || "current-to-best/1".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value = (Double)this.currentSolution.getVariableValue(j) + this.k * ((Double)parentSolutions.get(2).getVariableValue(j) - (Double)this.currentSolution.getVariableValue(j)) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                if (value < child.getLowerBound(j)) {
                    value = child.getLowerBound(j);
                }
                if (value > child.getUpperBound(j)) {
                    value = child.getUpperBound(j);
                }
                child.setVariableValue(j, value);
            }
        } else if ("current-to-rand/1/bin".equals(this.variant) || "current-to-best/1/bin".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value;
                if (this.randomGenerator.nextDouble(0.0, 1.0) < this.cr || j == jrand) {
                    value = (Double)this.currentSolution.getVariableValue(j) + this.k * ((Double)parentSolutions.get(2).getVariableValue(j) - (Double)this.currentSolution.getVariableValue(j)) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                    if (value < child.getLowerBound(j)) {
                        value = child.getLowerBound(j);
                    }
                    if (value > child.getUpperBound(j)) {
                        value = child.getUpperBound(j);
                    }
                    child.setVariableValue(j, value);
                    continue;
                }
                value = (Double)this.currentSolution.getVariableValue(j);
                child.setVariableValue(j, value);
            }
        } else if ("current-to-rand/1/exp".equals(this.variant) || "current-to-best/1/exp".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value;
                if (this.randomGenerator.nextDouble(0.0, 1.0) < this.cr || j == jrand) {
                    value = (Double)this.currentSolution.getVariableValue(j) + this.k * ((Double)parentSolutions.get(2).getVariableValue(j) - (Double)this.currentSolution.getVariableValue(j)) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                    if (value < child.getLowerBound(j)) {
                        value = child.getLowerBound(j);
                    }
                    if (value > child.getUpperBound(j)) {
                        value = child.getUpperBound(j);
                    }
                    child.setVariableValue(j, value);
                    continue;
                }
                this.cr = 0.0;
                value = (Double)this.currentSolution.getVariableValue(j);
                child.setVariableValue(j, value);
            }
        } else {
            JMetalLogger.logger.severe("DifferentialEvolutionCrossover.execute:  unknown DE variant (" + this.variant + ")");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMetalException("Exception in " + name + ".execute()");
        }
        ArrayList<DoubleSolution> result = new ArrayList<DoubleSolution>(1);
        result.add(child);
        return result;
    }
}

