/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class UniformMutation
implements MutationOperator<DoubleSolution> {
    private Double perturbation;
    private Double mutationProbability = null;
    private JMetalRandom randomGenenerator;

    public UniformMutation(double mutationProbability, double perturbation) {
        this.mutationProbability = mutationProbability;
        this.perturbation = perturbation;
        this.randomGenenerator = JMetalRandom.getInstance();
    }

    public Double getPerturbation() {
        return this.perturbation;
    }

    public Double getMutationProbability() {
        return this.mutationProbability;
    }

    public void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            if (!(this.randomGenenerator.nextDouble() < probability)) continue;
            double rand = this.randomGenenerator.nextDouble();
            double tmp = (rand - 0.5) * this.perturbation;
            if ((tmp += ((Double)solution.getVariableValue(i)).doubleValue()) < solution.getLowerBound(i)) {
                tmp = solution.getLowerBound(i);
            } else if (tmp > solution.getUpperBound(i)) {
                tmp = solution.getUpperBound(i);
            }
            solution.setVariableValue(i, tmp);
        }
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }
}

