/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractEvolutionaryAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;

public abstract class AbstractGeneticAlgorithm<S extends Solution<?>, Result>
extends AbstractEvolutionaryAlgorithm<S, Result> {
    protected SelectionOperator<List<S>, S> selectionOperator;
    protected CrossoverOperator<S> crossoverOperator;
    protected MutationOperator<S> mutationOperator;

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public AbstractGeneticAlgorithm(Problem<S> problem) {
        this.setProblem(problem);
    }

    @Override
    protected List<S> createInitialPopulation() {
        ArrayList population = new ArrayList(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            Object newIndividual = this.getProblem().createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(population.size());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        int numberOfParents = this.crossoverOperator.getNumberOfParents();
        this.checkNumberOfParents(population, numberOfParents);
        ArrayList<Solution> offspringPopulation = new ArrayList<Solution>(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); i += numberOfParents) {
            ArrayList<S> parents = new ArrayList<S>(numberOfParents);
            for (int j = 0; j < numberOfParents; ++j) {
                parents.add(population.get(i + j));
            }
            List offspring = (List)this.crossoverOperator.execute(parents);
            for (Solution s : offspring) {
                this.mutationOperator.execute(s);
                offspringPopulation.add(s);
            }
        }
        return offspringPopulation;
    }

    protected void checkNumberOfParents(List<S> population, int numberOfParentsForCrossover) {
        if (population.size() % numberOfParentsForCrossover != 0) {
            throw new JMetalException("Wrong number of parents: the remainder if the population size (" + population.size() + ") is not divisible by " + numberOfParentsForCrossover);
        }
    }
}

