/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionUtils;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class SolutionListUtils {
    public static <S extends Solution<?>> List<S> getNondominatedSolutions(List<S> solutionList) {
        DominanceRanking<S> ranking = new DominanceRanking<S>();
        return ranking.computeRanking(solutionList).getSubfront(0);
    }

    public <S extends Solution<?>> S findWorstSolution(Collection<S> solutionList, Comparator<S> comparator) {
        if (solutionList == null || solutionList.isEmpty()) {
            throw new IllegalArgumentException("No solution provided: " + solutionList);
        }
        Solution worstKnown = (Solution)solutionList.iterator().next();
        for (Solution candidateSolution : solutionList) {
            if (comparator.compare(worstKnown, candidateSolution) >= 0) continue;
            worstKnown = candidateSolution;
        }
        return (S)worstKnown;
    }

    public static <S extends Solution<?>> int findIndexOfBestSolution(List<S> solutionList, Comparator<S> comparator) {
        if (solutionList == null) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.isEmpty()) {
            throw new JMetalException("The solution list is empty");
        }
        if (comparator == null) {
            throw new JMetalException("The comparator is null");
        }
        int index = 0;
        Solution bestKnown = (Solution)solutionList.get(0);
        for (int i = 1; i < solutionList.size(); ++i) {
            Solution candidateSolution = (Solution)solutionList.get(i);
            int flag = comparator.compare(bestKnown, candidateSolution);
            if (flag != 1) continue;
            index = i;
            bestKnown = candidateSolution;
        }
        return index;
    }

    public static int findIndexOfWorstSolution(List<? extends Solution<?>> solutionList, Comparator<Solution<?>> comparator) {
        if (solutionList == null) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.isEmpty()) {
            throw new JMetalException("The solution list is empty");
        }
        if (comparator == null) {
            throw new JMetalException("The comparator is null");
        }
        int index = 0;
        Solution<?> worstKnown = solutionList.get(0);
        for (int i = 1; i < solutionList.size(); ++i) {
            Solution<?> candidateSolution = solutionList.get(i);
            int flag = comparator.compare(worstKnown, candidateSolution);
            if (flag != -1) continue;
            index = i;
            worstKnown = candidateSolution;
        }
        return index;
    }

    public static <S extends Solution<?>> S findBestSolution(List<S> solutionList, Comparator<S> comparator) {
        return (S)((Solution)solutionList.get(SolutionListUtils.findIndexOfBestSolution(solutionList, comparator)));
    }

    public static <S extends Solution<?>> double[][] writeObjectivesToMatrix(List<S> solutionList) {
        if (solutionList.size() == 0) {
            return new double[0][0];
        }
        int numberOfObjectives = ((Solution)solutionList.get(0)).getNumberOfObjectives();
        int solutionListSize = solutionList.size();
        double[][] objectives = new double[solutionListSize][numberOfObjectives];
        for (int i = 0; i < solutionListSize; ++i) {
            for (int j = 0; j < numberOfObjectives; ++j) {
                objectives[i][j] = ((Solution)solutionList.get(i)).getObjective(j);
            }
        }
        return objectives;
    }

    public static List<Solution<?>> getNormalizedFront(List<Solution<?>> solutionList, List<Double> maximumValue, List<Double> minimumValue) {
        ArrayList normalizedSolutionSet = new ArrayList(solutionList.size());
        int numberOfObjectives = solutionList.get(0).getNumberOfObjectives();
        for (int i = 0; i < solutionList.size(); ++i) {
            Solution<?> solution = solutionList.get(i).copy();
            for (int j = 0; j < numberOfObjectives; ++j) {
                double normalizedValue = (solutionList.get(i).getObjective(j) - minimumValue.get(j)) / (maximumValue.get(j) - minimumValue.get(j));
                solution.setObjective(j, normalizedValue);
            }
        }
        return normalizedSolutionSet;
    }

    public static <S extends Solution<?>> List<S> getInvertedFront(List<S> solutionSet) {
        ArrayList invertedFront = new ArrayList(solutionSet.size());
        int numberOfObjectives = ((Solution)solutionSet.get(0)).getNumberOfObjectives();
        for (int i = 0; i < solutionSet.size(); ++i) {
            invertedFront.add(i, ((Solution)solutionSet.get(i)).copy());
            for (int j = 0; j < numberOfObjectives; ++j) {
                if (((Solution)solutionSet.get(i)).getObjective(j) <= 1.0 && ((Solution)solutionSet.get(i)).getObjective(j) >= 0.0) {
                    ((Solution)invertedFront.get(i)).setObjective(j, 1.0 - ((Solution)solutionSet.get(i)).getObjective(j));
                    continue;
                }
                if (((Solution)solutionSet.get(i)).getObjective(j) > 1.0) {
                    ((Solution)invertedFront.get(i)).setObjective(j, 0.0);
                    continue;
                }
                if (!(((Solution)solutionSet.get(i)).getObjective(j) < 0.0)) continue;
                ((Solution)invertedFront.get(i)).setObjective(j, 1.0);
            }
        }
        return invertedFront;
    }

    public static <S extends Solution<?>> boolean isSolutionDominatedBySolutionList(S solution, List<? extends S> solutionSet) {
        boolean result = false;
        DominanceComparator dominance = new DominanceComparator();
        for (int i = 0; !result && i < solutionSet.size(); ++i) {
            if (dominance.compare(solution, solutionSet.get(i)) != 1) continue;
            result = true;
        }
        return result;
    }

    public static <S extends Solution<?>> List<S> selectNRandomDifferentSolutions(int numberOfSolutionsToBeReturned, List<S> solutionList) {
        if (null == solutionList) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.size() == 0) {
            throw new JMetalException("The solution list is empty");
        }
        if (solutionList.size() < numberOfSolutionsToBeReturned) {
            throw new JMetalException("The solution list size (" + solutionList.size() + ") is less than " + "the number of requested solutions (" + numberOfSolutionsToBeReturned + ")");
        }
        JMetalRandom randomGenerator = JMetalRandom.getInstance();
        ArrayList<S> resultList = new ArrayList<S>(numberOfSolutionsToBeReturned);
        if (solutionList.size() == 1) {
            resultList.add(solutionList.get(0));
        } else {
            HashSet<Integer> positions = new HashSet<Integer>(numberOfSolutionsToBeReturned);
            while (positions.size() < numberOfSolutionsToBeReturned) {
                int nextPosition = randomGenerator.nextInt(0, solutionList.size() - 1);
                if (positions.contains(nextPosition)) continue;
                positions.add(nextPosition);
                resultList.add(solutionList.get(nextPosition));
            }
        }
        return resultList;
    }

    public static <S extends Solution<?>> double[][] distanceMatrix(List<S> solutionSet) {
        double[][] distance = new double[solutionSet.size()][solutionSet.size()];
        for (int i = 0; i < solutionSet.size(); ++i) {
            distance[i][i] = 0.0;
            for (int j = i + 1; j < solutionSet.size(); ++j) {
                distance[i][j] = SolutionUtils.distanceBetweenObjectives((Solution)solutionSet.get(i), (Solution)solutionSet.get(j));
                distance[j][i] = distance[i][j];
            }
        }
        return distance;
    }

    public static <S extends Solution<?>> boolean solutionListsAreEquals(List<S> solutionList, List<S> newSolutionList) {
        for (int i = 0; i < solutionList.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < newSolutionList.size(); ++j) {
                if (!((Solution)solutionList.get(i)).equals(newSolutionList.get(j))) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static <S extends Solution<?>> void restart(List<S> solutionList, Problem<S> problem, int percentageOfSolutionsToRemove) {
        if (solutionList == null) {
            throw new JMetalException("The solution list is null");
        }
        if (problem == null) {
            throw new JMetalException("The problem is null");
        }
        if (percentageOfSolutionsToRemove < 0 || percentageOfSolutionsToRemove > 100) {
            throw new JMetalException("The percentage of solutions to remove is invalid: " + percentageOfSolutionsToRemove);
        }
        int solutionListOriginalSize = solutionList.size();
        int numberOfSolutionsToRemove = (int)((double)(solutionListOriginalSize * percentageOfSolutionsToRemove) / 100.0);
        SolutionListUtils.removeSolutionsFromList(solutionList, numberOfSolutionsToRemove);
        SolutionListUtils.fillPopulationWithNewSolutions(solutionList, problem, solutionListOriginalSize);
    }

    public static <S extends Solution<?>> void removeSolutionsFromList(List<S> solutionList, int numberOfSolutionsToRemove) {
        if (solutionList.size() < numberOfSolutionsToRemove) {
            throw new JMetalException("The list size (" + solutionList.size() + ") is lower than " + "the number of solutions to remove (" + numberOfSolutionsToRemove + ")");
        }
        for (int i = 0; i < numberOfSolutionsToRemove; ++i) {
            solutionList.remove(0);
        }
    }

    public static <S extends Solution<?>> void fillPopulationWithNewSolutions(List<S> solutionList, Problem<S> problem, int maxListSize) {
        while (solutionList.size() < maxListSize) {
            solutionList.add(problem.createSolution());
        }
    }
}

