/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.qualityindicator.impl.Hypervolume;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.comparator.HypervolumeContributionComparator;

public class HypervolumeArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> comparator = new HypervolumeContributionComparator();
    Hypervolume<S> hypervolume;

    public HypervolumeArchive(int maxSize, Hypervolume<S> hypervolume) {
        super(maxSize);
        this.hypervolume = hypervolume;
    }

    @Override
    public void prune() {
        if (this.getSolutionList().size() > this.getMaxSize()) {
            this.computeDensityEstimator();
            Object worst = new SolutionListUtils().findWorstSolution(this.getSolutionList(), this.comparator);
            this.getSolutionList().remove(worst);
        }
    }

    @Override
    public Comparator<S> getComparator() {
        return this.comparator;
    }

    @Override
    public void computeDensityEstimator() {
        this.hypervolume.computeHypervolumeContribution(this.archive.getSolutionList(), this.archive.getSolutionList());
    }
}

