/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.fileoutput;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class SolutionListOutput {
    private FileOutputContext varFileContext = new DefaultFileOutputContext(this.varFileName);
    private FileOutputContext funFileContext = new DefaultFileOutputContext(this.funFileName);
    private String varFileName = "VAR";
    private String funFileName = "FUN";
    private String separator = "\t";
    private List<? extends Solution<?>> solutionList;
    private boolean selectFeasibleSolutions;
    private List<Boolean> isObjectiveToBeMinimized;

    public SolutionListOutput(List<? extends Solution<?>> solutionList) {
        this.varFileContext.setSeparator(this.separator);
        this.funFileContext.setSeparator(this.separator);
        this.solutionList = solutionList;
        this.selectFeasibleSolutions = false;
        this.isObjectiveToBeMinimized = null;
    }

    public SolutionListOutput setVarFileOutputContext(FileOutputContext fileContext) {
        this.varFileContext = fileContext;
        return this;
    }

    public SolutionListOutput setFunFileOutputContext(FileOutputContext fileContext) {
        this.funFileContext = fileContext;
        return this;
    }

    public SolutionListOutput setObjectiveMinimizingObjectiveList(List<Boolean> isObjectiveToBeMinimized) {
        this.isObjectiveToBeMinimized = isObjectiveToBeMinimized;
        return this;
    }

    public SolutionListOutput selectFeasibleSolutions() {
        this.selectFeasibleSolutions = true;
        return this;
    }

    public SolutionListOutput setSeparator(String separator) {
        this.separator = separator;
        this.varFileContext.setSeparator(this.separator);
        this.funFileContext.setSeparator(this.separator);
        return this;
    }

    public void print() {
        if (this.isObjectiveToBeMinimized == null) {
            this.printObjectivesToFile(this.funFileContext, this.solutionList);
        } else {
            this.printObjectivesToFile(this.funFileContext, this.solutionList, this.isObjectiveToBeMinimized);
        }
        this.printVariablesToFile(this.varFileContext, this.solutionList);
    }

    public void printVariablesToFile(FileOutputContext context, List<? extends Solution<?>> solutionList) {
        BufferedWriter bufferedWriter = context.getFileWriter();
        try {
            if (solutionList.size() > 0) {
                int numberOfVariables = solutionList.get(0).getNumberOfVariables();
                for (int i = 0; i < solutionList.size(); ++i) {
                    for (int j = 0; j < numberOfVariables; ++j) {
                        bufferedWriter.write(solutionList.get(i).getVariableValueString(j) + context.getSeparator());
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            throw new JMetalException("Error writing data ", e);
        }
    }

    public void printObjectivesToFile(FileOutputContext context, List<? extends Solution<?>> solutionList) {
        BufferedWriter bufferedWriter = context.getFileWriter();
        try {
            if (solutionList.size() > 0) {
                int numberOfObjectives = solutionList.get(0).getNumberOfObjectives();
                for (int i = 0; i < solutionList.size(); ++i) {
                    for (int j = 0; j < numberOfObjectives; ++j) {
                        bufferedWriter.write(solutionList.get(i).getObjective(j) + context.getSeparator());
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            throw new JMetalException("Error printing objecives to file: ", e);
        }
    }

    public void printObjectivesToFile(FileOutputContext context, List<? extends Solution<?>> solutionList, List<Boolean> minimizeObjective) {
        BufferedWriter bufferedWriter = context.getFileWriter();
        try {
            if (solutionList.size() > 0) {
                int numberOfObjectives = solutionList.get(0).getNumberOfObjectives();
                if (numberOfObjectives != minimizeObjective.size()) {
                    throw new JMetalException("The size of list minimizeObjective is not correct: " + minimizeObjective.size());
                }
                for (int i = 0; i < solutionList.size(); ++i) {
                    for (int j = 0; j < numberOfObjectives; ++j) {
                        if (minimizeObjective.get(j).booleanValue()) {
                            bufferedWriter.write(solutionList.get(i).getObjective(j) + context.getSeparator());
                            continue;
                        }
                        bufferedWriter.write(-1.0 * solutionList.get(i).getObjective(j) + context.getSeparator());
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            throw new JMetalException("Error printing objecives to file: ", e);
        }
    }

    public void printObjectivesToFile(String fileName) throws IOException {
        this.printObjectivesToFile(new DefaultFileOutputContext(fileName), this.solutionList);
    }

    public void printObjectivesToFile(String fileName, List<Boolean> minimizeObjective) throws IOException {
        this.printObjectivesToFile(new DefaultFileOutputContext(fileName), this.solutionList, minimizeObjective);
    }

    public void printVariablesToFile(String fileName) throws IOException {
        this.printVariablesToFile(new DefaultFileOutputContext(fileName), this.solutionList);
    }
}

