/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.referencePoint.impl;

import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.referencePoint.ReferencePoint;

public class IdealPoint
extends ReferencePoint {
    private static final double DEFAULT_INITIAL_VALUE = Double.POSITIVE_INFINITY;

    public IdealPoint(int numberOfPoints) {
        super(numberOfPoints);
        for (int i = 0; i < numberOfPoints; ++i) {
            this.setObjective(i, Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public void update(Solution<?> solution) {
        if (solution == null) {
            throw new JMetalException("The solution is null");
        }
        if (solution.getNumberOfObjectives() != this.getNumberOfObjectives()) {
            throw new JMetalException("The number of objectives of the solution (" + solution.getNumberOfObjectives() + ") " + "is different to the size of the reference point(" + this.getNumberOfObjectives() + ")");
        }
        for (int i = 0; i < this.getNumberOfObjectives(); ++i) {
            if (!(this.getObjective(i) > solution.getObjective(i))) continue;
            this.setObjective(i, solution.getObjective(i));
        }
    }
}

