/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.crossover;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class DifferentialEvolutionCrossover
implements CrossoverOperator<DoubleSolution> {
    private static final double DEFAULT_CR = 0.5;
    private static final double DEFAULT_F = 0.5;
    private static final double DEFAULT_K = 0.5;
    private static final String DEFAULT_DE_VARIANT = "rand/1/bin";
    private double cr;
    private double f;
    private double k;
    private String variant;
    private DoubleSolution currentSolution;
    private BoundedRandomGenerator<Integer> jRandomGenerator;
    private BoundedRandomGenerator<Double> crRandomGenerator;

    public DifferentialEvolutionCrossover() {
        this(0.5, 0.5, 0.5, DEFAULT_DE_VARIANT);
    }

    public DifferentialEvolutionCrossover(double cr, double f, String variant) {
        this(cr, f, variant, (a2, b) -> JMetalRandom.getInstance().nextInt((int)a2, (int)b), (a2, b) -> JMetalRandom.getInstance().nextDouble((double)a2, (double)b));
    }

    public DifferentialEvolutionCrossover(double cr, double f, String variant, RandomGenerator<Double> randomGenerator) {
        this(cr, f, variant, BoundedRandomGenerator.fromDoubleToInteger(randomGenerator), BoundedRandomGenerator.bound(randomGenerator));
    }

    public DifferentialEvolutionCrossover(double cr, double f, String variant, BoundedRandomGenerator<Integer> jRandomGenerator, BoundedRandomGenerator<Double> crRandomGenerator) {
        this.cr = cr;
        this.f = f;
        this.k = 0.5;
        this.variant = variant;
        this.jRandomGenerator = jRandomGenerator;
        this.crRandomGenerator = crRandomGenerator;
    }

    public DifferentialEvolutionCrossover(double cr, double f, double k, String variant) {
        this(cr, f, variant);
        this.k = k;
    }

    public double getCr() {
        return this.cr;
    }

    public double getF() {
        return this.f;
    }

    public double getK() {
        return this.k;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setCurrentSolution(DoubleSolution current) {
        this.currentSolution = current;
    }

    public void setCr(double cr) {
        this.cr = cr;
    }

    public void setF(double f) {
        this.f = f;
    }

    public void setK(double k) {
        this.k = k;
    }

    @Override
    public List<DoubleSolution> execute(List<DoubleSolution> parentSolutions) {
        int j;
        DoubleSolution child = (DoubleSolution)this.currentSolution.copy();
        int numberOfVariables = parentSolutions.get(0).getNumberOfVariables();
        int jrand = this.jRandomGenerator.getRandomValue(0, numberOfVariables - 1);
        if (DEFAULT_DE_VARIANT.equals(this.variant) || "best/1/bin".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value;
                if (this.crRandomGenerator.getRandomValue(0.0, 1.0) < this.cr || j == jrand) {
                    value = (Double)parentSolutions.get(2).getVariableValue(j) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                    if (value < child.getLowerBound(j)) {
                        value = child.getLowerBound(j);
                    }
                    if (value > child.getUpperBound(j)) {
                        value = child.getUpperBound(j);
                    }
                    child.setVariableValue(j, value);
                    continue;
                }
                value = (Double)this.currentSolution.getVariableValue(j);
                child.setVariableValue(j, value);
            }
        } else if ("rand/1/exp".equals(this.variant) || "best/1/exp".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value;
                if (this.crRandomGenerator.getRandomValue(0.0, 1.0) < this.cr || j == jrand) {
                    value = (Double)parentSolutions.get(2).getVariableValue(j) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                    if (value < child.getLowerBound(j)) {
                        value = child.getLowerBound(j);
                    }
                    if (value > child.getUpperBound(j)) {
                        value = child.getUpperBound(j);
                    }
                    child.setVariableValue(j, value);
                    continue;
                }
                this.cr = 0.0;
                value = (Double)this.currentSolution.getVariableValue(j);
                child.setVariableValue(j, value);
            }
        } else if ("current-to-rand/1".equals(this.variant) || "current-to-best/1".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value = (Double)this.currentSolution.getVariableValue(j) + this.k * ((Double)parentSolutions.get(2).getVariableValue(j) - (Double)this.currentSolution.getVariableValue(j)) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                if (value < child.getLowerBound(j)) {
                    value = child.getLowerBound(j);
                }
                if (value > child.getUpperBound(j)) {
                    value = child.getUpperBound(j);
                }
                child.setVariableValue(j, value);
            }
        } else if ("current-to-rand/1/bin".equals(this.variant) || "current-to-best/1/bin".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value;
                if (this.crRandomGenerator.getRandomValue(0.0, 1.0) < this.cr || j == jrand) {
                    value = (Double)this.currentSolution.getVariableValue(j) + this.k * ((Double)parentSolutions.get(2).getVariableValue(j) - (Double)this.currentSolution.getVariableValue(j)) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                    if (value < child.getLowerBound(j)) {
                        value = child.getLowerBound(j);
                    }
                    if (value > child.getUpperBound(j)) {
                        value = child.getUpperBound(j);
                    }
                    child.setVariableValue(j, value);
                    continue;
                }
                value = (Double)this.currentSolution.getVariableValue(j);
                child.setVariableValue(j, value);
            }
        } else if ("current-to-rand/1/exp".equals(this.variant) || "current-to-best/1/exp".equals(this.variant)) {
            for (j = 0; j < numberOfVariables; ++j) {
                double value;
                if (this.crRandomGenerator.getRandomValue(0.0, 1.0) < this.cr || j == jrand) {
                    value = (Double)this.currentSolution.getVariableValue(j) + this.k * ((Double)parentSolutions.get(2).getVariableValue(j) - (Double)this.currentSolution.getVariableValue(j)) + this.f * ((Double)parentSolutions.get(0).getVariableValue(j) - (Double)parentSolutions.get(1).getVariableValue(j));
                    if (value < child.getLowerBound(j)) {
                        value = child.getLowerBound(j);
                    }
                    if (value > child.getUpperBound(j)) {
                        value = child.getUpperBound(j);
                    }
                    child.setVariableValue(j, value);
                    continue;
                }
                this.cr = 0.0;
                value = (Double)this.currentSolution.getVariableValue(j);
                child.setVariableValue(j, value);
            }
        } else {
            JMetalLogger.logger.severe("DifferentialEvolutionCrossover.execute:  unknown DE variant (" + this.variant + ")");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMetalException("Exception in " + name + ".execute()");
        }
        ArrayList<DoubleSolution> result = new ArrayList<DoubleSolution>(1);
        result.add(child);
        return result;
    }

    @Override
    public int getNumberOfParents() {
        return 3;
    }
}

