/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class UniformMutation
implements MutationOperator<DoubleSolution> {
    private double perturbation;
    private Double mutationProbability = null;
    private RandomGenerator<Double> randomGenenerator;

    public UniformMutation(double mutationProbability, double perturbation) {
        this(mutationProbability, perturbation, () -> JMetalRandom.getInstance().nextDouble());
    }

    public UniformMutation(double mutationProbability, double perturbation, RandomGenerator<Double> randomGenenerator) {
        this.mutationProbability = mutationProbability;
        this.perturbation = perturbation;
        this.randomGenenerator = randomGenenerator;
    }

    public double getPerturbation() {
        return this.perturbation;
    }

    public Double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setPerturbation(Double perturbation) {
        this.perturbation = perturbation;
    }

    public void setMutationProbability(Double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    public void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            if (!(this.randomGenenerator.getRandomValue() < probability)) continue;
            double rand = this.randomGenenerator.getRandomValue();
            double tmp = (rand - 0.5) * this.perturbation;
            if ((tmp += ((Double)solution.getVariableValue(i)).doubleValue()) < solution.getLowerBound(i)) {
                tmp = solution.getLowerBound(i);
            } else if (tmp > solution.getUpperBound(i)) {
                tmp = solution.getUpperBound(i);
            }
            solution.setVariableValue(i, tmp);
        }
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }
}

