/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.selection;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.DominanceComparator;

public class NaryTournamentSelection<S extends Solution<?>>
implements SelectionOperator<List<S>, S> {
    private Comparator<S> comparator;
    private int numberOfSolutionsToBeReturned;

    public NaryTournamentSelection() {
        this(2, new DominanceComparator());
    }

    public NaryTournamentSelection(int numberOfSolutionsToBeReturned, Comparator<S> comparator) {
        this.numberOfSolutionsToBeReturned = numberOfSolutionsToBeReturned;
        this.comparator = comparator;
    }

    @Override
    public S execute(List<S> solutionList) {
        Solution result;
        if (null == solutionList) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.isEmpty()) {
            throw new JMetalException("The solution list is empty");
        }
        if (solutionList.size() < this.numberOfSolutionsToBeReturned) {
            throw new JMetalException("The solution list size (" + solutionList.size() + ") is less than the number of requested solutions (" + this.numberOfSolutionsToBeReturned + ")");
        }
        if (solutionList.size() == 1) {
            result = (Solution)solutionList.get(0);
        } else {
            List<S> selectedSolutions = SolutionListUtils.selectNRandomDifferentSolutions(this.numberOfSolutionsToBeReturned, solutionList);
            result = (Solution)SolutionListUtils.findBestSolution(selectedSolutions, this.comparator);
        }
        return (S)result;
    }
}

