/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.point.util.comparator.LexicographicalPointComparator;
import org.uma.jmetal.util.point.util.distance.EuclideanDistance;

public class Spread<S extends Solution<?>>
extends GenericIndicator<S> {
    public Spread() {
    }

    public Spread(String referenceParetoFrontFile) throws FileNotFoundException {
        super(referenceParetoFrontFile);
    }

    public Spread(Front referenceParetoFront) {
        super(referenceParetoFront);
    }

    @Override
    public Double evaluate(List<S> solutionList) {
        return this.spread(new ArrayFront(solutionList), this.referenceParetoFront);
    }

    public double spread(Front front, Front referenceFront) {
        int i;
        EuclideanDistance distance = new EuclideanDistance();
        front.sort(new LexicographicalPointComparator());
        referenceFront.sort(new LexicographicalPointComparator());
        double df = distance.compute(front.getPoint(0), referenceFront.getPoint(0));
        double dl = distance.compute(front.getPoint(front.getNumberOfPoints() - 1), referenceFront.getPoint(referenceFront.getNumberOfPoints() - 1));
        double mean = 0.0;
        double diversitySum = df + dl;
        int numberOfPoints = front.getNumberOfPoints();
        for (i = 0; i < numberOfPoints - 1; ++i) {
            mean += distance.compute(front.getPoint(i), front.getPoint(i + 1));
        }
        mean /= (double)(numberOfPoints - 1);
        if (numberOfPoints > 1) {
            for (i = 0; i < numberOfPoints - 1; ++i) {
                diversitySum += Math.abs(distance.compute(front.getPoint(i), front.getPoint(i + 1)) - mean);
            }
            return diversitySum / (df + dl + (double)(numberOfPoints - 1) * mean);
        }
        return 1.0;
    }

    @Override
    public String getName() {
        return "SPREAD";
    }

    @Override
    public String getDescription() {
        return "Spread quality indicator";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }
}

