/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public abstract class AbstractGenericSolution<T, P extends Problem<?>>
implements Solution<T> {
    private double[] objectives;
    private List<T> variables;
    protected P problem;
    protected Map<Object, Object> attributes;
    protected final JMetalRandom randomGenerator;

    protected AbstractGenericSolution(P problem) {
        this.problem = problem;
        this.attributes = new HashMap<Object, Object>();
        this.randomGenerator = JMetalRandom.getInstance();
        this.objectives = new double[problem.getNumberOfObjectives()];
        this.variables = new ArrayList<T>(problem.getNumberOfVariables());
        for (int i = 0; i < problem.getNumberOfVariables(); ++i) {
            this.variables.add(i, null);
        }
    }

    @Override
    public void setAttribute(Object id, Object value) {
        this.attributes.put(id, value);
    }

    @Override
    public Object getAttribute(Object id) {
        return this.attributes.get(id);
    }

    @Override
    public void setObjective(int index, double value) {
        this.objectives[index] = value;
    }

    @Override
    public double getObjective(int index) {
        return this.objectives[index];
    }

    @Override
    public T getVariableValue(int index) {
        return this.variables.get(index);
    }

    @Override
    public void setVariableValue(int index, T value) {
        this.variables.set(index, value);
    }

    @Override
    public int getNumberOfVariables() {
        return this.variables.size();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.objectives.length;
    }

    protected void initializeObjectiveValues() {
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.objectives[i] = 0.0;
        }
    }

    public String toString() {
        String result = "Variables: ";
        for (T var : this.variables) {
            result = result + "" + var + " ";
        }
        result = result + "Objectives: ";
        Object object = this.objectives;
        int n = ((Object)object).length;
        for (int i = 0; i < n; ++i) {
            Double obj = (double)object[i];
            result = result + "" + obj + " ";
        }
        result = result + "\t";
        result = result + "AlgorithmAttributes: " + this.attributes + "\n";
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractGenericSolution that = (AbstractGenericSolution)o;
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        if (!Arrays.equals(this.objectives, that.objectives)) {
            return false;
        }
        return this.variables.equals(that.variables);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.objectives);
        result = 31 * result + this.variables.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return result;
    }
}

