/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.ArrayDoubleSolution;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.EqualSolutionsComparator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class NonDominatedSolutionListArchive<S extends Solution<?>>
implements Archive<S> {
    private List<S> solutionList;
    private Comparator<S> dominanceComparator;
    private Comparator<S> equalSolutions = new EqualSolutionsComparator();

    public NonDominatedSolutionListArchive() {
        this(new DominanceComparator());
    }

    public NonDominatedSolutionListArchive(DominanceComparator<S> comparator) {
        this.dominanceComparator = comparator;
        this.solutionList = new ArrayList<S>();
    }

    @Override
    public boolean add(S solution) {
        boolean solutionInserted = false;
        if (this.solutionList.size() != 0) {
            Iterator<S> iterator = this.solutionList.iterator();
            boolean isDominated = false;
            boolean isContained = false;
            while (!isDominated && !isContained && iterator.hasNext()) {
                int equalflag;
                Solution listIndividual = (Solution)iterator.next();
                int flag = this.dominanceComparator.compare(solution, listIndividual);
                if (flag == -1) {
                    iterator.remove();
                    continue;
                }
                if (flag == 1) {
                    isDominated = true;
                    continue;
                }
                if (flag != 0 || (equalflag = this.equalSolutions.compare(solution, listIndividual)) != 0) continue;
                isContained = true;
            }
            if (!isDominated && !isContained) {
                this.solutionList.add(solution);
                solutionInserted = true;
            }
            return solutionInserted;
        }
        this.solutionList.add(solution);
        solutionInserted = true;
        return solutionInserted;
    }

    @Override
    public List<S> getSolutionList() {
        return this.solutionList;
    }

    @Override
    public int size() {
        return this.solutionList.size();
    }

    @Override
    public S get(int index) {
        return (S)((Solution)this.solutionList.get(index));
    }

    public static void main(String[] args) {
        JMetalRandom.getInstance().setSeed(1L);
        NonDominatedSolutionListArchive<DoubleSolution> archive = new NonDominatedSolutionListArchive<DoubleSolution>();
        MockedDoubleProblem1 problem = new MockedDoubleProblem1(100);
        long initTime = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            DoubleSolution solution = (DoubleSolution)problem.createSolution();
            problem.evaluate(solution);
            archive.add(solution);
        }
        System.out.println("Time: " + (System.currentTimeMillis() - initTime));
    }

    private static class MockedDoubleProblem1
    extends AbstractDoubleProblem {
        public MockedDoubleProblem1(int numberOfVariables) {
            this.setNumberOfVariables(numberOfVariables);
            this.setNumberOfObjectives(2);
            this.setNumberOfConstraints(0);
            ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
            ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
            for (int i = 0; i < this.getNumberOfVariables(); ++i) {
                lowerLimit.add(0.0);
                upperLimit.add(1.0);
            }
            this.setLowerLimit(lowerLimit);
            this.setUpperLimit(upperLimit);
        }

        @Override
        public void evaluate(DoubleSolution solution) {
            double[] f = new double[this.getNumberOfObjectives()];
            f[0] = (Double)solution.getVariableValue(0) + 0.0;
            double g = this.evalG(solution);
            double h = this.evalH(f[0], g);
            f[1] = h * g;
            solution.setObjective(0, f[0]);
            solution.setObjective(1, f[1]);
        }

        private double evalG(DoubleSolution solution) {
            double g = 0.0;
            for (int i = 1; i < solution.getNumberOfVariables(); ++i) {
                g += ((Double)solution.getVariableValue(i)).doubleValue();
            }
            double constant = 9.0 / ((double)solution.getNumberOfVariables() - 1.0);
            g = constant * g;
            return g += 1.0;
        }

        public double evalH(double f, double g) {
            double h = 1.0 - Math.sqrt(f / g);
            return h;
        }

        @Override
        public DoubleSolution createSolution() {
            return new ArrayDoubleSolution(this);
        }
    }
}

