/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.comparator.ConstraintViolationComparator;
import org.uma.jmetal.util.comparator.impl.OverallConstraintViolationComparator;

public class DominanceComparator<S extends Solution<?>>
implements Comparator<S>,
Serializable {
    private ConstraintViolationComparator<S> constraintViolationComparator;

    public DominanceComparator() {
        this(new OverallConstraintViolationComparator(), 0.0);
    }

    public DominanceComparator(double epsilon) {
        this(new OverallConstraintViolationComparator(), epsilon);
    }

    public DominanceComparator(ConstraintViolationComparator<S> constraintComparator) {
        this(constraintComparator, 0.0);
    }

    public DominanceComparator(ConstraintViolationComparator<S> constraintComparator, double epsilon) {
        this.constraintViolationComparator = constraintComparator;
    }

    @Override
    public int compare(S solution1, S solution2) {
        if (solution1 == null) {
            throw new JMetalException("Solution1 is null");
        }
        if (solution2 == null) {
            throw new JMetalException("Solution2 is null");
        }
        if (solution1.getNumberOfObjectives() != solution2.getNumberOfObjectives()) {
            throw new JMetalException("Cannot compare because solution1 has " + solution1.getNumberOfObjectives() + " objectives and solution2 has " + solution2.getNumberOfObjectives());
        }
        int result = this.constraintViolationComparator.compare(solution1, solution2);
        if (result == 0) {
            result = this.dominanceTest(solution1, solution2);
        }
        return result;
    }

    private int dominanceTest(S solution1, S solution2) {
        boolean bestIsOne = false;
        boolean bestIsTwo = false;
        for (int i = 0; i < solution1.getNumberOfObjectives(); ++i) {
            double value2;
            double value1 = solution1.getObjective(i);
            if (value1 == (value2 = solution2.getObjective(i))) continue;
            if (value1 < value2) {
                bestIsOne = true;
            }
            if (!(value2 < value1)) continue;
            bestIsTwo = true;
        }
        int result = bestIsOne > bestIsTwo ? -1 : (bestIsTwo > bestIsOne ? 1 : 0);
        return result;
    }
}

