/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class ExperimentBuilder<S extends Solution<?>, Result> {
    private final String experimentName;
    private List<ExperimentAlgorithm<S, Result>> algorithmList;
    private List<ExperimentProblem<S>> problemList;
    private List<String> referenceFrontFileNames;
    private String referenceFrontDirectory;
    private String experimentBaseDirectory;
    private String outputParetoFrontFileName;
    private String outputParetoSetFileName;
    private int independentRuns;
    private List<GenericIndicator<S>> indicatorList;
    private int numberOfCores;

    public ExperimentBuilder(String experimentName) {
        this.experimentName = experimentName;
        this.independentRuns = 1;
        this.numberOfCores = 1;
        this.referenceFrontFileNames = null;
        this.referenceFrontDirectory = null;
    }

    public ExperimentBuilder<S, Result> setAlgorithmList(List<ExperimentAlgorithm<S, Result>> algorithmList) {
        this.algorithmList = new ArrayList<ExperimentAlgorithm<S, Result>>(algorithmList);
        return this;
    }

    public ExperimentBuilder<S, Result> setProblemList(List<ExperimentProblem<S>> problemList) {
        this.problemList = problemList;
        return this;
    }

    public ExperimentBuilder<S, Result> setExperimentBaseDirectory(String experimentBaseDirectory) {
        this.experimentBaseDirectory = experimentBaseDirectory + "/" + this.experimentName;
        return this;
    }

    public ExperimentBuilder<S, Result> setReferenceFrontDirectory(String referenceFrontDirectory) {
        this.referenceFrontDirectory = referenceFrontDirectory;
        return this;
    }

    public ExperimentBuilder<S, Result> setReferenceFrontFileNames(List<String> referenceFrontFileNames) {
        this.referenceFrontFileNames = referenceFrontFileNames;
        return this;
    }

    public ExperimentBuilder<S, Result> setIndicatorList(List<GenericIndicator<S>> indicatorList) {
        this.indicatorList = indicatorList;
        return this;
    }

    public ExperimentBuilder<S, Result> setOutputParetoFrontFileName(String outputParetoFrontFileName) {
        this.outputParetoFrontFileName = outputParetoFrontFileName;
        return this;
    }

    public ExperimentBuilder<S, Result> setOutputParetoSetFileName(String outputParetoSetFileName) {
        this.outputParetoSetFileName = outputParetoSetFileName;
        return this;
    }

    public ExperimentBuilder<S, Result> setIndependentRuns(int independentRuns) {
        this.independentRuns = independentRuns;
        return this;
    }

    public ExperimentBuilder<S, Result> setNumberOfCores(int numberOfCores) {
        this.numberOfCores = numberOfCores;
        return this;
    }

    public Experiment<S, Result> build() {
        return new Experiment(this);
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public List<ExperimentAlgorithm<S, Result>> getAlgorithmList() {
        return this.algorithmList;
    }

    public List<ExperimentProblem<S>> getProblemList() {
        return this.problemList;
    }

    public String getExperimentBaseDirectory() {
        return this.experimentBaseDirectory;
    }

    public String getOutputParetoFrontFileName() {
        return this.outputParetoFrontFileName;
    }

    public String getOutputParetoSetFileName() {
        return this.outputParetoSetFileName;
    }

    public int getIndependentRuns() {
        return this.independentRuns;
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public List<String> getReferenceFrontFileNames() {
        return this.referenceFrontFileNames;
    }

    public String getReferenceFrontDirectory() {
        return this.referenceFrontDirectory;
    }

    public List<GenericIndicator<S>> getIndicatorList() {
        return this.indicatorList;
    }
}

