/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.util.distance;

import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.util.distance.PointDistance;

public class DominanceDistance
implements PointDistance {
    @Override
    public double compute(Point a2, Point b) {
        if (a2 == null) {
            throw new JMetalException("The first point is null");
        }
        if (b == null) {
            throw new JMetalException("The second point is null");
        }
        if (a2.getNumberOfDimensions() != b.getNumberOfDimensions()) {
            throw new JMetalException("The dimensions of the points are different: " + a2.getNumberOfDimensions() + ", " + b.getNumberOfDimensions());
        }
        double distance = 0.0;
        for (int i = 0; i < a2.getNumberOfDimensions(); ++i) {
            double max = Math.max(b.getDimensionValue(i) - a2.getDimensionValue(i), 0.0);
            distance += Math.pow(max, 2.0);
        }
        return Math.sqrt(distance);
    }
}

