/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.solutionattribute.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.impl.OverallConstraintViolationComparator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class DominanceRanking<S extends Solution<?>>
extends GenericSolutionAttribute<S, Integer>
implements Ranking<S> {
    private static final Comparator<Solution<?>> DOMINANCE_COMPARATOR = new DominanceComparator();
    private static final Comparator<Solution<?>> CONSTRAINT_VIOLATION_COMPARATOR = new OverallConstraintViolationComparator();
    private List<ArrayList<S>> rankedSubPopulations = new ArrayList<ArrayList<S>>();

    public DominanceRanking() {
    }

    public DominanceRanking(Object id) {
        super(id);
    }

    @Override
    public Ranking<S> computeRanking(List<S> solutionSet) {
        int i;
        List<S> population = solutionSet;
        int[] dominateMe = new int[population.size()];
        ArrayList iDominate = new ArrayList(population.size());
        ArrayList front = new ArrayList(population.size() + 1);
        for (int i2 = 0; i2 < population.size() + 1; ++i2) {
            front.add(new LinkedList());
        }
        for (int p = 0; p < population.size(); ++p) {
            iDominate.add(new LinkedList());
            dominateMe[p] = 0;
        }
        for (int p = 0; p < population.size() - 1; ++p) {
            for (int q = p + 1; q < population.size(); ++q) {
                int flagDominate = CONSTRAINT_VIOLATION_COMPARATOR.compare((Solution<?>)solutionSet.get(p), (Solution<?>)solutionSet.get(q));
                if (flagDominate == 0) {
                    flagDominate = DOMINANCE_COMPARATOR.compare((Solution<?>)solutionSet.get(p), (Solution<?>)solutionSet.get(q));
                }
                if (flagDominate == -1) {
                    ((List)iDominate.get(p)).add(q);
                    int n = q;
                    dominateMe[n] = dominateMe[n] + 1;
                    continue;
                }
                if (flagDominate != 1) continue;
                ((List)iDominate.get(q)).add(p);
                int n = p;
                dominateMe[n] = dominateMe[n] + 1;
            }
        }
        for (i = 0; i < population.size(); ++i) {
            if (dominateMe[i] != 0) continue;
            ((List)front.get(0)).add(i);
            ((Solution)solutionSet.get(i)).setAttribute(this.getAttributeIdentifier(), 0);
        }
        i = 0;
        while (((List)front.get(i)).size() != 0) {
            Iterator it1 = ((List)front.get(++i - 1)).iterator();
            while (it1.hasNext()) {
                Iterator it2 = ((List)iDominate.get((Integer)it1.next())).iterator();
                while (it2.hasNext()) {
                    int index;
                    int n = index = ((Integer)it2.next()).intValue();
                    dominateMe[n] = dominateMe[n] - 1;
                    if (dominateMe[index] != 0) continue;
                    ((List)front.get(i)).add(index);
                    ((Solution)solutionSet.get(index)).setAttribute(this.getAttributeIdentifier(), i);
                }
            }
        }
        this.rankedSubPopulations = new ArrayList<ArrayList<S>>();
        for (int j = 0; j < i; ++j) {
            this.rankedSubPopulations.add(j, new ArrayList(((List)front.get(j)).size()));
            Iterator it1 = ((List)front.get(j)).iterator();
            while (it1.hasNext()) {
                this.rankedSubPopulations.get(j).add(solutionSet.get((Integer)it1.next()));
            }
        }
        return this;
    }

    @Override
    public List<S> getSubfront(int rank) {
        if (rank >= this.rankedSubPopulations.size()) {
            throw new JMetalException("Invalid rank: " + rank + ". Max rank = " + (this.rankedSubPopulations.size() - 1));
        }
        return this.rankedSubPopulations.get(rank);
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.rankedSubPopulations.size();
    }
}

