/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.crossover;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.RandomGenerator;

public class HUXCrossover
implements CrossoverOperator<BinarySolution> {
    private double crossoverProbability;
    private RandomGenerator<Double> randomGenerator;

    public HUXCrossover(double crossoverProbability) {
        this(crossoverProbability, () -> JMetalRandom.getInstance().nextDouble());
    }

    public HUXCrossover(double crossoverProbability, RandomGenerator<Double> randomGenerator) {
        if (crossoverProbability < 0.0) {
            throw new JMetalException("Crossover probability is negative: " + crossoverProbability);
        }
        this.crossoverProbability = crossoverProbability;
        this.randomGenerator = randomGenerator;
    }

    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    @Override
    public List<BinarySolution> execute(List<BinarySolution> parents) {
        if (parents.size() != 2) {
            throw new JMetalException("HUXCrossover.execute: operator needs two parents");
        }
        return this.doCrossover(this.crossoverProbability, parents.get(0), parents.get(1));
    }

    public List<BinarySolution> doCrossover(double probability, BinarySolution parent1, BinarySolution parent2) throws JMetalException {
        ArrayList<BinarySolution> offspring = new ArrayList<BinarySolution>();
        offspring.add((BinarySolution)parent1.copy());
        offspring.add((BinarySolution)parent2.copy());
        if (this.randomGenerator.getRandomValue() < probability) {
            for (int var = 0; var < parent1.getNumberOfVariables(); ++var) {
                BinarySet p1 = (BinarySet)parent1.getVariableValue(var);
                BinarySet p2 = (BinarySet)parent2.getVariableValue(var);
                for (int bit = 0; bit < p1.size(); ++bit) {
                    if (p1.get(bit) == p2.get(bit) || !(this.randomGenerator.getRandomValue() < 0.5)) continue;
                    ((BinarySet)((BinarySolution)offspring.get(0)).getVariableValue(var)).set(bit, p2.get(bit));
                    ((BinarySet)((BinarySolution)offspring.get(1)).getVariableValue(var)).set(bit, p1.get(bit));
                }
            }
        }
        return offspring;
    }

    @Override
    public int getNumberOfParents() {
        return 2;
    }
}

